/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.stream.Stream;
import org.aksw.commons.io.util.FileUtils;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.txn.api.Txn;
import org.aksw.commons.txn.api.TxnMgr;
import org.aksw.commons.txn.api.TxnResourceApi;
import org.aksw.commons.txn.impl.FileSync;
import org.aksw.commons.txn.impl.TxnHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnUtils {
    private static final Logger logger = LoggerFactory.getLogger(TxnUtils.class);

    public static void cleanupStaleTxns(TxnMgr txnMgr, TxnHandler handler) throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("Checking existing txns...");
        }
        try (Stream<Txn> stream = txnMgr.streamTxns();){
            stream.forEach(txn -> {
                block3: {
                    try {
                        if (txn.claim()) {
                            TxnUtils.rollbackOrEnd(txn, handler);
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block3;
                        logger.warn("Failed to process txn", (Throwable)e);
                    }
                }
            });
        }
    }

    public static void precommit(Txn txn, TxnHandler handler) throws Exception, IOException {
        try (Stream<Path<String>> stream = txn.streamAccessedResourcePaths();){
            Iterator it = stream.iterator();
            while (it.hasNext()) {
                Path relPath = (Path)it.next();
                TxnResourceApi api = txn.getResourceApi((Path<String>)relPath);
                if (!api.getTxnResourceLock().ownsWriteLock()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Syncing: " + String.valueOf(relPath));
                }
                handler.beforePreCommit((Path<String>)relPath);
                FileSync fs = api.getFileSync();
                fs.preCommit();
                handler.afterPreCommit((Path<String>)relPath);
            }
        }
    }

    public static void commit(Txn txn, TxnHandler handler) {
        try {
            TxnUtils.precommit(txn, handler);
            txn.addCommit();
            TxnUtils.applyJournal(txn, handler);
        }
        catch (Exception e) {
            try {
                if (txn.isCommit()) {
                    throw new RuntimeException("Failed to finalize commit after pre-commit", e);
                }
                txn.addRollback();
            }
            catch (Exception e2) {
                e2.addSuppressed(e);
                throw new RuntimeException(e2);
            }
            try {
                TxnUtils.applyJournal(txn, handler);
            }
            catch (Exception e2) {
                e2.addSuppressed(e);
                throw new RuntimeException(e2);
            }
            throw new RuntimeException(e);
        }
        finally {
            handler.end();
        }
    }

    @Deprecated
    public static void applyJournalOld(Txn txn, TxnHandler handler) {
        boolean isCommit;
        TxnMgr txnMgr = txn.getTxnMgr();
        java.nio.file.Path resRepoRootPath = txnMgr.getRootPath();
        try {
            isCommit = txn.isCommit() && !txn.isRollback();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        try {
            if (isCommit) {
                txn.addFinalize();
            }
            try (Stream<Path<String>> stream = txn.streamAccessedResourcePaths();){
                Iterator it = stream.iterator();
                while (it.hasNext()) {
                    Path res = (Path)it.next();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Finalizing and unlocking: " + String.valueOf(res));
                    }
                    TxnResourceApi api = txn.getResourceApi((Path<String>)res);
                    Path<String> resourceKey = api.getResourceKey();
                    java.nio.file.Path targetFile = api.getFileSync().getTargetFile();
                    if (isCommit) {
                        api.finalizeCommit();
                    } else {
                        api.rollback();
                    }
                    FileUtils.deleteEmptyFolders((java.nio.file.Path)targetFile.getParent(), (java.nio.file.Path)resRepoRootPath, (boolean)true);
                    handler.beforeUnlock(resourceKey, isCommit);
                    api.unlock();
                    api.undeclareAccess();
                }
            }
            txn.cleanUpTxn();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void applyJournal(Txn txn, TxnHandler handler) {
        TxnUtils.finalizeCommit(txn);
        TxnUtils.unlock(txn, handler);
    }

    public static void finalizeCommit(Txn txn) {
        boolean isCommit;
        TxnMgr txnMgr = txn.getTxnMgr();
        java.nio.file.Path resRepoRootPath = txnMgr.getRootPath();
        try {
            isCommit = txn.isCommit() && !txn.isRollback();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        try {
            if (isCommit) {
                txn.addFinalize();
            }
            try (Stream<Path<String>> stream = txn.streamAccessedResourcePaths();){
                Iterator it = stream.iterator();
                while (it.hasNext()) {
                    Path res = (Path)it.next();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Finalizing: " + String.valueOf(res));
                    }
                    TxnResourceApi api = txn.getResourceApi((Path<String>)res);
                    Path<String> resourceKey = api.getResourceKey();
                    java.nio.file.Path targetFile = api.getFileSync().getTargetFile();
                    if (isCommit) {
                        api.finalizeCommit();
                    } else {
                        api.rollback();
                    }
                    FileUtils.deleteEmptyFolders((java.nio.file.Path)targetFile.getParent(), (java.nio.file.Path)resRepoRootPath, (boolean)true);
                }
            }
            txn.cleanUpTxn();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void unlock(Txn txn, TxnHandler handler) {
        boolean isCommit;
        try {
            isCommit = txn.isCommit() && !txn.isRollback();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        try {
            try (Stream<Path<String>> stream = txn.streamAccessedResourcePaths();){
                Iterator it = stream.iterator();
                while (it.hasNext()) {
                    Path res = (Path)it.next();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Unlocking: " + String.valueOf(res));
                    }
                    TxnResourceApi api = txn.getResourceApi((Path<String>)res);
                    Path<String> resourceKey = api.getResourceKey();
                    handler.beforeUnlock(resourceKey, isCommit);
                    api.unlock();
                    api.undeclareAccess();
                }
            }
            txn.cleanUpTxn();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void abort(Txn txn, TxnHandler handler) {
        try {
            txn.addRollback();
            TxnUtils.applyJournal(txn, handler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            handler.end();
        }
    }

    public static void rollbackOrEnd(Txn txn, TxnHandler handler) throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("Detected stale txn; applying rollback: " + txn.getId());
        }
        if (!txn.isCommit()) {
            txn.addRollback();
        }
        TxnUtils.applyJournal(txn, handler);
    }
}

