/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Instant;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.lock.db.api.ReadWriteLockWithOwnership;
import org.aksw.commons.lock.db.api.ResourceLock;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.txn.impl.FileUtilsExtra;
import org.aksw.commons.txn.impl.TxnResourceApiReadUncommitted;
import org.aksw.commons.txn.impl.TxnSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnResourceApiSerializable
extends TxnResourceApiReadUncommitted<TxnSerializable> {
    private static final Logger logger = LoggerFactory.getLogger(TxnResourceApiSerializable.class);
    protected java.nio.file.Path journalEntryFile;
    protected ResourceLock<String> resourceLock;
    protected ReadWriteLockWithOwnership txnResourceLock;
    protected Cache<Path<String>, Boolean> accessCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public TxnResourceApiSerializable(TxnSerializable txn, Path<String> resKey) {
        super(txn, resKey);
        String resKeyStr = resKey.toString();
        this.resourceLock = txn.txnMgr.lockStore.getLockForResource(resKeyStr);
        this.txnResourceLock = this.resourceLock.get(txn.txnId);
        String[] resLockKey = txn.txnMgr.lockRepo.getPathSegments(resKeyStr);
        String resLockKeyStr = PathUtils.join((String[])resLockKey);
        this.journalEntryFile = txn.txnFolder.resolve("." + resLockKeyStr);
    }

    @Override
    public ReadWriteLockWithOwnership getTxnResourceLock() {
        return this.txnResourceLock;
    }

    @Override
    public boolean isVisible() {
        boolean result;
        if (this.txnResourceLock.isLockedHere()) {
            result = true;
        } else {
            Instant resTime;
            Instant txnTime = ((TxnSerializable)this.txn).getCreationDate();
            try {
                resTime = this.fileSync.getLastModifiedTime();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            result = resTime != null && resTime.isBefore(txnTime);
        }
        return result;
    }

    @Override
    public void declareAccess() {
        try {
            this.accessCache.get((Object)this.resKey, () -> {
                this.declareAccessCore();
                return true;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void declareAccessCore() {
        java.nio.file.Path actualLinkTarget = ((TxnSerializable)this.txn).txnFolder.relativize(this.resFileAbsPath);
        try {
            if (Files.exists(this.journalEntryFile, LinkOption.NOFOLLOW_LINKS)) {
                boolean verifyAccess = false;
                if (verifyAccess) {
                    logger.debug("Verifying access " + String.valueOf(this.journalEntryFile));
                    java.nio.file.Path link = ((TxnSerializable)this.txn).txnMgr.symlinkStrategy.readSymbolicLink(this.journalEntryFile);
                    if (!link.equals(actualLinkTarget)) {
                        throw new RuntimeException(String.format("Validation failed: Attempted to declare access to %s but a different %s already existed ", actualLinkTarget, link));
                    }
                }
            } else {
                logger.debug("Declaring access from " + String.valueOf(this.journalEntryFile) + " to " + String.valueOf(actualLinkTarget));
                FileUtilsExtra.ensureParentFolderExists(this.journalEntryFile, () -> {
                    try {
                        ((TxnSerializable)this.txn).txnMgr.symlinkStrategy.createSymbolicLink(this.journalEntryFile, actualLinkTarget);
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                        // empty catch block
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void undeclareAccess() {
        this.accessCache.invalidate((Object)this.resKey);
        try {
            Files.deleteIfExists(this.journalEntryFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

