/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.function.Consumer;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.lock.db.api.ReadWriteLockWithOwnership;
import org.aksw.commons.lock.db.impl.LockOwnerDummy;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.txn.api.TxnResourceApi;
import org.aksw.commons.txn.impl.FileSyncImpl;
import org.aksw.commons.txn.impl.TxnReadUncommitted;

public class TxnResourceApiReadUncommitted<T extends TxnReadUncommitted>
implements TxnResourceApi {
    protected T txn;
    protected Path<String> resKey;
    protected java.nio.file.Path resFilePath;
    protected java.nio.file.Path resFileAbsPath;
    protected FileSyncImpl fileSync;

    public TxnResourceApiReadUncommitted(T txn, Path<String> resKey) {
        this.txn = txn;
        this.resKey = resKey;
        this.resFileAbsPath = PathUtils.resolve((java.nio.file.Path)((TxnReadUncommitted)txn).txnMgr.getRootPath(), (Iterable)resKey.getSegments()).normalize();
        this.fileSync = FileSyncImpl.create(this.resFileAbsPath, true);
    }

    @Override
    public ReadWriteLockWithOwnership getTxnResourceLock() {
        return new LockOwnerDummy();
    }

    @Override
    public Instant getLastModifiedDate() throws IOException {
        return this.fileSync.getLastModifiedTime();
    }

    @Override
    public Path<String> getResourceKey() {
        return this.resKey;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void declareAccess() {
    }

    @Override
    public void undeclareAccess() {
    }

    @Override
    public FileSyncImpl getFileSync() {
        return this.fileSync;
    }

    public void putContent(Consumer<OutputStream> handler) throws IOException {
        this.fileSync.putContent(handler);
    }

    @Override
    public void preCommit() throws Exception {
        this.fileSync.preCommit();
    }

    @Override
    public void finalizeCommit() throws Exception {
        this.fileSync.finalizeCommit();
    }

    @Override
    public void rollback() throws Exception {
        this.fileSync.rollback();
    }
}

