/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.aksw.commons.txn.impl.FileSyncImpl;
import org.aksw.commons.util.function.ThrowingRunnable;

public class FileUtilsExtra {
    public static Stream<Path> streamFilenames(Path folder) throws IOException {
        return Files.list(folder).map(path -> path.resolveSibling(FileSyncImpl.getBaseName(path.getFileName().toString())));
    }

    public static <T> T ensureParentFolderExists(Path childPath, ThrowingRunnable action) throws IOException {
        return (T)FileUtilsExtra.ensureParentFolderExists(childPath, () -> {
            action.run();
            return null;
        });
    }

    public static <T> T ensureParentFolderExists(Path childPath, Callable<T> action) throws IOException {
        T result;
        Path parentPath = childPath.getParent();
        if (parentPath == null) {
            try {
                result = action.call();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            result = FileUtilsExtra.ensureFolderExists(parentPath, action);
        }
        return result;
    }

    public static <T> T ensureFolderExists(Path folderPath, ThrowingRunnable action) throws IOException {
        return (T)FileUtilsExtra.ensureFolderExists(folderPath, () -> {
            action.run();
            return null;
        });
    }

    public static <T> T ensureFolderExists(Path folderPath, Callable<T> action) throws IOException {
        T result = null;
        for (int i = 0; i < 10; ++i) {
            try {
                Files.createDirectories(folderPath, new FileAttribute[0]);
                result = action.call();
                break;
            }
            catch (Exception e) {
                if (!Files.exists(folderPath, new LinkOption[0])) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                throw new IOException(e);
            }
        }
        return result;
    }
}

