/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.lock.db.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.io.util.symlink.SymbolicLinkStrategy;
import org.aksw.commons.lock.db.api.LockStore;
import org.aksw.commons.lock.db.api.ReadWriteLockWithOwnership;
import org.aksw.commons.lock.db.api.ResourceLock;
import org.aksw.commons.lock.db.impl.LockFromLink;
import org.aksw.commons.lock.db.impl.LockFromLockStore;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathStr;
import org.aksw.commons.txn.impl.ResourceRepository;

public class LockStoreImpl
implements LockStore<String[], String> {
    protected String readLockFilenamePattern = "*.read.lock";
    protected String writeLockFilename = "write.lock";
    protected String mgmtLockFilename = "mgmt.lock";
    protected SymbolicLinkStrategy symbolicLinkStrategy;
    protected ResourceRepository<String> lockRepo;
    protected Function<String, java.nio.file.Path> ownerRepoFactory;
    protected ResourceRepository<String> storeRepo;

    public LockStoreImpl(SymbolicLinkStrategy symbolicLinkStrategy, ResourceRepository<String> lockRepo, ResourceRepository<String> storeRepo, Function<String, java.nio.file.Path> ownerRepoFactory) {
        this.symbolicLinkStrategy = symbolicLinkStrategy;
        this.lockRepo = lockRepo;
        this.storeRepo = storeRepo;
        this.ownerRepoFactory = ownerRepoFactory;
    }

    @Override
    public ResourceLock<String> getLockForResource(String resource) {
        String[] storeKey = this.storeRepo.getPathSegments(resource);
        String tmpKey = Arrays.asList(storeKey).stream().collect(Collectors.joining("/"));
        String[] lockKey = this.lockRepo.getPathSegments(tmpKey);
        return this.getLockByKey((Path<String>)PathStr.newRelativePath((String[])lockKey));
    }

    @Override
    public ResourceLock<String> getLockByKey(Path<String> lockKey) {
        return new ResourceLockImpl(lockKey);
    }

    @Override
    public Stream<ResourceLock<String>> streamResourceLocks() throws IOException {
        return Files.walk(this.lockRepo.getRootPath(), new FileVisitOption[0]).map(PathUtils::getPathSegments).map(PathStr::newRelativePath).map(this::getLockByKey);
    }

    public class ResourceLockImpl
    implements ResourceLock<String> {
        protected Path<String> lockKey;
        protected java.nio.file.Path lockAbsPath;
        protected java.nio.file.Path mgmtLockPath;
        protected java.nio.file.Path writeLockPath;

        public ResourceLockImpl(Path<String> lockKey) {
            this.lockKey = lockKey;
            this.lockAbsPath = PathUtils.resolve((java.nio.file.Path)LockStoreImpl.this.lockRepo.getRootPath(), (Iterable)lockKey.getSegments());
            this.mgmtLockPath = this.lockAbsPath.resolve(LockStoreImpl.this.mgmtLockFilename);
            this.writeLockPath = this.lockAbsPath.resolve(LockStoreImpl.this.writeLockFilename);
        }

        @Override
        public String getMgmtLockOwnerKey() {
            String result = this.getOwnerKey(this.mgmtLockPath);
            return result;
        }

        public java.nio.file.Path getWriteLock() {
            java.nio.file.Path writeLockFile = this.lockAbsPath.resolve(LockStoreImpl.this.writeLockFilename);
            return writeLockFile;
        }

        @Override
        public ReadWriteLockWithOwnership get(String ownerKey) {
            return this.createLockOwner(ownerKey);
        }

        public Stream<java.nio.file.Path> streamReadLockPaths() throws IOException {
            PathMatcher pathMatcher = LockStoreImpl.this.lockRepo.getRootPath().getFileSystem().getPathMatcher("glob:" + LockStoreImpl.this.readLockFilenamePattern);
            return Files.exists(this.lockAbsPath, new LinkOption[0]) ? Files.list(this.lockAbsPath).filter(pathMatcher::matches) : Stream.empty();
        }

        public String linkTargetToKey(java.nio.file.Path path) {
            String result = path.getFileName().toString();
            return result;
        }

        public String getOwnerKey(java.nio.file.Path linkFile) {
            String result;
            try {
                java.nio.file.Path target = LockStoreImpl.this.symbolicLinkStrategy.readSymbolicLink(linkFile);
                result = this.linkTargetToKey(target);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                result = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        @Override
        public Stream<String> streamReadLockOwnerKeys() throws IOException {
            return this.streamReadLockPaths().map(this::getOwnerKey);
        }

        @Override
        public String getWriteLockOwnerKey() throws IOException {
            String result = this.getOwnerKey(this.writeLockPath);
            return result;
        }

        protected LockFromLockStore createLockOwner(String ownerKey) {
            java.nio.file.Path lockRepoRootPath = LockStoreImpl.this.lockRepo.getRootPath();
            String readLockFileName = ownerKey + ".read.lock";
            java.nio.file.Path readLockPath = this.lockAbsPath.resolve(readLockFileName);
            LockFromLink readLock = new LockFromLink(LockStoreImpl.this.symbolicLinkStrategy, readLockPath, ownerKey, LockStoreImpl.this.ownerRepoFactory, this::linkTargetToKey, lockRepoRootPath);
            LockFromLink writeLock = new LockFromLink(LockStoreImpl.this.symbolicLinkStrategy, this.writeLockPath, ownerKey, LockStoreImpl.this.ownerRepoFactory, this::linkTargetToKey, lockRepoRootPath);
            LockFromLink mgmtLock = new LockFromLink(LockStoreImpl.this.symbolicLinkStrategy, this.lockAbsPath.resolve(LockStoreImpl.this.mgmtLockFilename), ownerKey, LockStoreImpl.this.ownerRepoFactory, this::linkTargetToKey, lockRepoRootPath);
            return new LockFromLockStore(this, ownerKey, mgmtLock, readLock, writeLock);
        }
    }
}

