/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.lock;

import java.nio.file.Path;
import java.util.concurrent.locks.Condition;
import org.aksw.commons.lock.LockBaseRepeat;
import org.aksw.commons.lock.db.impl.LockFromFile;

public class ProcessFileLock
extends LockBaseRepeat {
    protected LockFromFile lock;
    protected transient Thread thread;

    public ProcessFileLock(Path path) {
        this.lock = new LockFromFile(path);
        this.thread = null;
    }

    @Override
    protected boolean singleLockAttempt() throws InterruptedException {
        boolean result;
        Thread currentThread = Thread.currentThread();
        if (this.thread == null) {
            result = this.lock.singleLockAttempt();
            this.thread = Thread.currentThread();
        } else if (this.thread == currentThread) {
            result = true;
        } else {
            throw new RuntimeException("Attempt to re-lock a lock instance from a different thread");
        }
        return result;
    }

    @Override
    public void unlock() {
        if (this.thread != null) {
            this.lock.unlock();
            this.thread = null;
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }
}

