/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.lock;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileLockUtils.class);
    private static final Map<Path, State> pathToState = new HashMap<Path, State>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ref<FileChannel> open(Path path, boolean readLockRequested, OpenOption ... openOptions) throws IOException, InterruptedException {
        State state;
        Path norm = path.normalize();
        Map<Path, State> map = pathToState;
        synchronized (map) {
            state = pathToState.get(norm);
            if (state == null) {
                logger.info("Requesting process lock for: " + String.valueOf(path));
                state = new State();
                state.fileChannel = FileChannel.open(path, openOptions);
                state.processLock = state.fileChannel.lock(0L, Long.MAX_VALUE, readLockRequested);
                logger.info("Acquired process lock for: " + String.valueOf(path));
                state.threadLock = new Semaphore(1);
                pathToState.put(norm, state);
            } else {
                logger.warn("There is already a process lock on: " + String.valueOf(path));
            }
        }
        logger.info("Requesting thread lock for: " + String.valueOf(path));
        state.threadLock.acquire();
        logger.info("Acquired thread lock for: " + String.valueOf(path));
        State s = state;
        Ref result = RefImpl.create((Object)s.fileChannel, null, () -> {
            Map<Path, State> map = pathToState;
            synchronized (map) {
                logger.info("Released locks for: " + String.valueOf(path));
                s.processLock.close();
                s.fileChannel.close();
                pathToState.remove(norm);
                s.threadLock.release();
            }
        }, null);
        return result;
    }

    public static class State {
        public FileChannel fileChannel;
        public FileLock processLock;
        public Semaphore threadLock;
    }
}

