/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.impl;

import java.nio.file.Path;
import java.util.function.Function;
import org.aksw.commons.io.util.UriToPathUtils;
import org.aksw.commons.txn.impl.ResourceRepository;
import org.aksw.commons.util.string.StringUtils;

public class ResourceRepoImpl
implements ResourceRepository<String> {
    protected Path rootPath;
    protected Function<String, String[]> resToPath;

    public ResourceRepoImpl(Path rootPath, Function<String, String[]> resToRelPath) {
        this.rootPath = rootPath;
        this.resToPath = resToRelPath;
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }

    @Override
    public String[] getPathSegments(String name) {
        String[] result = this.resToPath.apply(name);
        return result;
    }

    public static ResourceRepository<String> createWithUriToPath(Path rootPath) {
        return new ResourceRepoImpl(rootPath, UriToPathUtils::toPathSegments);
    }

    public static ResourceRepository<String> createWithUrlEncode(Path rootPath) {
        return new ResourceRepoImpl(rootPath, ResourceRepoImpl::stringToPath);
    }

    public static String[] stringToPath(String name) {
        String str = StringUtils.urlEncode((String)name);
        if (str.length() > 64) {
            str = StringUtils.md5Hash((String)str);
        }
        return new String[]{str};
    }
}

