/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.lock.db.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.aksw.commons.lambda.throwing.ThrowingConsumer;
import org.aksw.commons.lock.LockBaseRepeat;
import org.aksw.commons.lock.LockManagerPath;

public class LockFromFile
extends LockBaseRepeat {
    protected Path path;
    protected ThrowingConsumer<? super Path> fileCreator;

    public LockFromFile(Path path) {
        this.path = path;
        this.fileCreator = (ThrowingConsumer & Serializable)p -> Files.createFile(p, new FileAttribute[0]);
    }

    public LockFromFile(Path path, ThrowingConsumer<Path> fileCreator) {
        this.path = path;
        this.fileCreator = fileCreator;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean singleLockAttempt() throws InterruptedException {
        boolean result = LockManagerPath.tryCreateFile(this.path);
        return result;
    }

    @Override
    public void unlock() {
        try {
            Files.deleteIfExists(this.path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

