/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;
import org.aksw.commons.io.util.FileUtils;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.lock.db.impl.LockFromFile;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathOpsStr;
import org.aksw.commons.path.core.PathStr;
import org.aksw.commons.txn.api.TxnResourceApi;
import org.aksw.commons.txn.impl.TxnMgrImpl;
import org.aksw.commons.txn.impl.TxnReadUncommitted;
import org.aksw.commons.txn.impl.TxnResourceApiSerializable;
import org.aksw.commons.util.exception.FinallyRunAll;
import org.aksw.commons.util.function.ThrowingRunnable;
import org.aksw.commons.util.lock.LockUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnSerializable
extends TxnReadUncommitted {
    private static final Logger logger = LoggerFactory.getLogger(TxnSerializable.class);
    protected Duration mgmtLockTtl = Duration.ofSeconds(10L);
    protected TxnMgrImpl txnMgr;
    protected String txnId;
    protected java.nio.file.Path txnFolder;
    protected String commitFilename = "commit";
    protected String finalizeFilename = "finalize";
    protected String rollbackFilename = "rollback";
    protected transient java.nio.file.Path commitFile;
    protected transient java.nio.file.Path finalizeFile;
    protected transient java.nio.file.Path rollbackFile;
    protected String ownerFilename = "owner";
    protected transient java.nio.file.Path ownerFile;
    protected String mgmtLockFilename = "mgmt.lock";
    protected transient java.nio.file.Path mgmtLockFile;
    protected transient LockFromFile mgmtLock;

    @Override
    public String getId() {
        return this.txnId;
    }

    @Override
    protected TxnResourceApi createResourceApi(Path<String> key) {
        return new TxnResourceApiSerializable(this, key);
    }

    public TxnSerializable(TxnMgrImpl txnMgr, String txnId, java.nio.file.Path txnFolder) {
        super(txnMgr, txnId);
        this.txnMgr = txnMgr;
        this.txnId = txnId;
        this.txnFolder = txnFolder;
        this.commitFile = txnFolder.resolve(this.commitFilename);
        this.finalizeFile = txnFolder.resolve(this.finalizeFilename);
        this.rollbackFile = txnFolder.resolve(this.rollbackFilename);
        this.ownerFile = txnFolder.resolve(this.ownerFilename);
        this.mgmtLockFile = txnFolder.resolve(this.mgmtLockFilename);
        this.mgmtLock = new LockFromFile(this.mgmtLockFile);
    }

    @Override
    public Instant getCreationDate() {
        try {
            BasicFileAttributes attr = Files.readAttributes(this.txnFolder, BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = attr.creationTime();
            if (fileTime == null) {
                logger.warn("Failed to obtain creation time of " + String.valueOf(this.txnFolder) + " falling back to last modified date");
                fileTime = Files.getLastModifiedTime(this.txnFolder, new LinkOption[0]);
            }
            return fileTime.toInstant();
        }
        catch (IOException e) {
            throw new RuntimeException("Likely use of iterator outside of txn", e);
        }
    }

    public TxnResourceApi getResourceApi(String resourceName) {
        String[] resRelPath = this.txnMgr.getResRepo().getPathSegments(resourceName);
        PathStr rrp = PathOpsStr.get().newPath(false, Arrays.asList(resRelPath));
        TxnResourceApi result = this.getResourceApi((Path<String>)rrp);
        return result;
    }

    @Override
    public TxnResourceApi getResourceApi(Path<String> resRelPath) {
        TxnResourceApi result;
        try {
            result = (TxnResourceApi)this.containerCache.get(resRelPath);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public boolean isWrite() {
        boolean result = Files.exists(this.txnFolder.resolve("write"), new LinkOption[0]);
        return result;
    }

    @Override
    public void cleanUpTxn() throws IOException {
        FinallyRunAll.run((ThrowingRunnable[])new ThrowingRunnable[]{() -> Files.deleteIfExists(this.commitFile), () -> Files.deleteIfExists(this.finalizeFile), () -> Files.deleteIfExists(this.rollbackFile), () -> Files.deleteIfExists(this.txnFolder.resolve("write")), () -> Files.deleteIfExists(this.ownerFile), () -> FileUtils.deleteEmptyFolders((java.nio.file.Path)this.txnFolder, (java.nio.file.Path)this.txnMgr.txnBasePath, (boolean)true)});
    }

    @Override
    public void addCommit() throws IOException {
        Files.newOutputStream(this.commitFile, StandardOpenOption.CREATE).close();
    }

    @Override
    public void addFinalize() throws IOException {
        Files.newOutputStream(this.finalizeFile, StandardOpenOption.CREATE).close();
    }

    @Override
    public void addRollback() throws IOException {
        Files.newOutputStream(this.rollbackFile, StandardOpenOption.CREATE).close();
    }

    @Override
    public boolean isFinalize() throws IOException {
        return Files.exists(this.finalizeFile, new LinkOption[0]);
    }

    @Override
    public boolean isCommit() throws IOException {
        return Files.exists(this.commitFile, new LinkOption[0]);
    }

    @Override
    public boolean isRollback() throws IOException {
        return Files.exists(this.rollbackFile, new LinkOption[0]);
    }

    public Stream<java.nio.file.Path> streamAccessedEntries() throws IOException {
        return Files.list(this.txnFolder).map(path -> this.txnFolder.resolve((java.nio.file.Path)path).toAbsolutePath()).filter(path -> path.getFileName().toString().startsWith("."));
    }

    public Path<String> getRelPathForJournalEntry(java.nio.file.Path txnPath) {
        try {
            java.nio.file.Path txnToRes = this.txnMgr.symlinkStrategy.readSymbolicLink(txnPath);
            java.nio.file.Path resAbsPath = txnPath.resolveSibling(txnToRes).normalize();
            java.nio.file.Path resRelPath = this.txnMgr.getRootPath().relativize(resAbsPath);
            String[] array = PathUtils.getPathSegments((java.nio.file.Path)resRelPath);
            PathStr result = PathStr.newRelativePath((String[])array);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Stream<Path<String>> streamAccessedResourcePaths() throws IOException {
        return this.streamAccessedEntries().map(this::getRelPathForJournalEntry);
    }

    @Override
    public Instant getActivityDate() throws IOException {
        FileTime timestamp = Files.getLastModifiedTime(this.txnFolder, LinkOption.NOFOLLOW_LINKS);
        Instant result = timestamp.toInstant();
        return result;
    }

    @Override
    public void setActivityDate(Instant instant) throws IOException {
        FileTime timestamp = FileTime.from(instant);
        Files.setLastModifiedTime(this.txnFolder, timestamp);
    }

    @Override
    public boolean isStale() throws IOException {
        boolean result;
        try {
            TemporalAmount duration = this.getDurationToNextHeartbeat();
            result = Duration.from(duration).isNegative();
        }
        catch (NoSuchFileException e) {
            result = true;
        }
        return result;
    }

    public String getOwner() throws IOException {
        String result = Files.readString(this.ownerFile);
        return result;
    }

    public void writeOwner() throws IOException {
        String txnMgrId = this.txnMgr.getTxnMgrId();
        Files.writeString(this.ownerFile, (CharSequence)txnMgrId, new OpenOption[0]);
    }

    @Override
    public boolean claim() {
        boolean result = this.runWithMgmtLock(() -> {
            boolean r = false;
            if (this.isStale()) {
                String txnMgrId = this.txnMgr.getTxnMgrId();
                try {
                    String priorOwner = this.getOwner();
                    logger.info("Claiming stale transaction with txnMgrId: " + txnMgrId + " - prior owner was: " + priorOwner);
                }
                catch (NoSuchFileException e) {
                    String priorOwner = "(none)";
                }
                this.writeOwner();
                this.updateHeartbeatInternal();
                r = true;
            }
            return r;
        });
        return result;
    }

    protected void updateHeartbeatInternal() throws IOException {
        Instant now = Instant.now();
        Files.setLastModifiedTime(this.ownerFile, FileTime.from(now));
    }

    @Override
    public void updateHeartbeat() throws IOException {
        this.runWithVerifiedOwner(() -> {
            this.updateHeartbeatInternal();
            return null;
        });
    }

    @Override
    public Instant getMostRecentHeartbeat() throws IOException {
        FileTime fileTime = Files.getLastModifiedTime(this.ownerFile, new LinkOption[0]);
        Instant result = fileTime.toInstant();
        return result;
    }

    @Override
    public TemporalAmount getDurationToNextHeartbeat() throws IOException {
        Instant heartbeat = this.getMostRecentHeartbeat();
        TemporalAmount duration = this.txnMgr.getHeartbeatDuration();
        Instant nextHeartbeat = heartbeat.plus(duration);
        Instant now = Instant.now();
        Duration result = Duration.between(now, nextHeartbeat);
        return result;
    }

    protected <T> T runWithMgmtLock(Callable<T> action) {
        Object result = LockUtils.runWithMgmtLock((Lock)this.mgmtLock, LockFromFile::unlock, (Duration)this.mgmtLockTtl, () -> {
            Object r = action.call();
            return r;
        });
        return (T)result;
    }

    protected <T> T runWithVerifiedOwner(Callable<T> action) {
        String txnMgrId = this.getTxnMgr().getTxnMgrId();
        Object result = this.runWithMgmtLock(() -> {
            String ownerId = this.getOwner();
            if (!ownerId.equals(txnMgrId)) {
                throw new RuntimeException("Txn is not owned by " + txnMgrId + " - actual owner is: " + ownerId);
            }
            Object r = action.call();
            return r;
        });
        return (T)result;
    }
}

