/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.PathMatcher;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathNio;
import org.aksw.commons.path.core.PathStr;
import org.aksw.commons.txn.api.Txn;
import org.aksw.commons.txn.api.TxnMgr;
import org.aksw.commons.txn.api.TxnResourceApi;
import org.aksw.commons.txn.impl.TxnMgrImpl;
import org.aksw.commons.txn.impl.TxnResourceApiReadUncommitted;

public class TxnReadUncommitted
implements Txn {
    protected TxnMgrImpl txnMgr;
    protected String txnId;
    protected LoadingCache<Path<String>, TxnResourceApi> containerCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Path<String>, TxnResourceApi>(){

        public TxnResourceApi load(Path<String> key) throws Exception {
            return TxnReadUncommitted.this.createResourceApi(key);
        }
    });

    protected TxnResourceApi createResourceApi(Path<String> key) {
        return new TxnResourceApiReadUncommitted<TxnReadUncommitted>(this, key);
    }

    @Override
    public String getId() {
        return this.txnId;
    }

    @Override
    public void promote() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public TxnReadUncommitted(TxnMgrImpl txnMgr, String txnId) {
        this.txnMgr = txnMgr;
        this.txnId = txnId;
    }

    @Override
    public TxnMgr getTxnMgr() {
        return this.txnMgr;
    }

    @Override
    public Stream<TxnResourceApi> listVisibleFiles(Path<String> prefix) {
        Stream<TxnResourceApi> result;
        java.nio.file.Path rootPath = this.txnMgr.getRootPath();
        PathMatcher pathMatcher = this.txnMgr.getPathMatcher();
        java.nio.file.Path basePath = PathUtils.resolve((java.nio.file.Path)rootPath, (Iterable)prefix.getSegments());
        try {
            result = Files.exists(basePath, new LinkOption[0]) ? Files.walk(basePath, new FileVisitOption[0]).filter(path -> {
                boolean r = pathMatcher.matches((java.nio.file.Path)path);
                return r;
            }).map(path -> rootPath.relativize((java.nio.file.Path)path)).map(relPath -> (PathStr)PathStr.newRelativePath((String[])new String[0]).resolve((Path)PathNio.wrap((java.nio.file.Path)relPath))).map(this::getResourceApi).filter(TxnResourceApi::isVisible) : Stream.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public Instant getCreationDate() {
        return null;
    }

    @Override
    public TxnResourceApi getResourceApi(Path<String> resRelPath) {
        TxnResourceApi result;
        try {
            result = (TxnResourceApi)this.containerCache.get(resRelPath);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public boolean isWrite() {
        return false;
    }

    @Override
    public void cleanUpTxn() throws IOException {
    }

    @Override
    public void addCommit() throws IOException {
    }

    @Override
    public void addFinalize() throws IOException {
    }

    @Override
    public void addRollback() throws IOException {
    }

    @Override
    public boolean isFinalize() throws IOException {
        return true;
    }

    @Override
    public boolean isCommit() throws IOException {
        return true;
    }

    @Override
    public boolean isRollback() throws IOException {
        return false;
    }

    @Override
    public Stream<Path<String>> streamAccessedResourcePaths() throws IOException {
        return Stream.empty();
    }

    @Override
    public void setActivityDate(Instant instant) throws IOException {
    }

    @Override
    public Instant getActivityDate() throws IOException {
        return null;
    }

    @Override
    public boolean isStale() throws IOException {
        return false;
    }

    @Override
    public boolean claim() throws IOException {
        return false;
    }

    @Override
    public void updateHeartbeat() throws IOException {
    }

    @Override
    public Instant getMostRecentHeartbeat() throws IOException {
        return null;
    }

    @Override
    public TemporalAmount getDurationToNextHeartbeat() throws IOException {
        return null;
    }
}

