/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.impl;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Random;
import java.util.stream.Stream;
import org.aksw.commons.io.util.symlink.SymbolicLinkStrategies;
import org.aksw.commons.io.util.symlink.SymbolicLinkStrategy;
import org.aksw.commons.lock.LockManager;
import org.aksw.commons.lock.LockManagerPath;
import org.aksw.commons.lock.db.api.LockStore;
import org.aksw.commons.lock.db.impl.LockStoreImpl;
import org.aksw.commons.txn.api.Txn;
import org.aksw.commons.txn.api.TxnMgr;
import org.aksw.commons.txn.impl.FileUtilsExtra;
import org.aksw.commons.txn.impl.ResourceRepoImpl;
import org.aksw.commons.txn.impl.ResourceRepository;
import org.aksw.commons.txn.impl.TxnReadUncommitted;
import org.aksw.commons.txn.impl.TxnSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnMgrImpl
implements TxnMgr {
    private static final Logger logger = LoggerFactory.getLogger(TxnMgrImpl.class);
    protected Path rootPath;
    protected LockManager<Path> lockMgr;
    protected Path txnBasePath;
    protected ResourceRepository<String> resRepo;
    protected ResourceRepository<String> lockRepo;
    protected LockStore<String[], String> lockStore;
    protected SymbolicLinkStrategy symlinkStrategy;
    protected String txnMgrId;
    protected TemporalAmount heartbeatDuration;
    protected PathMatcher pathMatcher;

    public TxnMgrImpl(String txnMgrId, Path rootPath, PathMatcher pathMatcher, TemporalAmount heartbeatDuration, LockManager<Path> lockMgr, Path txnBasePath, ResourceRepository<String> resRepo, ResourceRepository<String> lockRepo, SymbolicLinkStrategy symlinkStrategy) {
        this.txnMgrId = txnMgrId;
        this.rootPath = rootPath;
        this.pathMatcher = pathMatcher;
        this.heartbeatDuration = heartbeatDuration;
        this.lockMgr = lockMgr;
        this.txnBasePath = txnBasePath;
        this.resRepo = resRepo;
        this.lockRepo = lockRepo;
        this.symlinkStrategy = symlinkStrategy;
        this.lockStore = new LockStoreImpl(symlinkStrategy, lockRepo, resRepo, txnId -> txnBasePath.resolve((String)txnId));
    }

    public static TxnMgrImpl createSimple(Path repoRoot) {
        ResourceRepository<String> resLocks = ResourceRepoImpl.createWithUrlEncode(repoRoot.resolve("locks"));
        return new TxnMgrImpl("txnMgr", repoRoot, repoRoot.getFileSystem().getPathMatcher("glob:**/*"), Duration.of(5L, ChronoUnit.SECONDS), new LockManagerPath(repoRoot), repoRoot.resolve("txns"), ResourceRepoImpl.createWithUrlEncode(repoRoot), resLocks, SymbolicLinkStrategies.FILE);
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Override
    public TemporalAmount getHeartbeatDuration() {
        return this.heartbeatDuration;
    }

    @Override
    public String getTxnMgrId() {
        return this.txnMgrId;
    }

    @Override
    public LockStore<String[], String> getLockStore() {
        return this.lockStore;
    }

    public void buildLockGraph() {
    }

    public SymbolicLinkStrategy getSymlinkStrategy() {
        return this.symlinkStrategy;
    }

    @Override
    public ResourceRepository<String> getResRepo() {
        return this.resRepo;
    }

    @Override
    public Txn getTxn(String txnId) {
        Path txnFolder = this.txnBasePath.resolve(txnId);
        TxnSerializable result = new TxnSerializable(this, txnId, txnFolder);
        return result;
    }

    @Override
    public Txn newTxn(String id, boolean useJournal, boolean isWrite) throws IOException {
        String txnId;
        String string = txnId = id == null ? "txn-" + new Random().nextLong() : id;
        if (useJournal) {
            Path txnFolder = this.txnBasePath.resolve(txnId);
            if (Files.exists(txnFolder, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("A transaction with id %s already exists", txnId));
            }
            Txn result = FileUtilsExtra.ensureFolderExists(txnFolder, () -> {
                try {
                    Files.createDirectories(txnFolder, new FileAttribute[0]);
                    if (isWrite) {
                        Files.createFile(txnFolder.resolve("write"), new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to lock txn folder; set useJournal=false if read only access with 'read uncommitted' isolation level is intended");
                }
                logger.debug("Allocated txn folder: " + String.valueOf(txnFolder));
                TxnSerializable r = new TxnSerializable(this, txnId, txnFolder);
                if (!r.claim()) {
                    throw new RuntimeException("Failed to claim ownership of the recently created txn " + txnId);
                }
                return r;
            });
            return result;
        }
        TxnReadUncommitted result = new TxnReadUncommitted(this, txnId);
        return result;
    }

    @Override
    public Stream<Txn> streamTxns() throws IOException {
        Stream<Path> baseStream = Files.exists(this.txnBasePath, new LinkOption[0]) ? Files.list(this.txnBasePath) : Stream.empty();
        return baseStream.map(path -> {
            String txnId = path.getFileName().toString();
            Txn r = this.getTxn(txnId);
            return r;
        });
    }

    @Override
    public void deleteResources() throws IOException {
        try {
            Path lockRepoRootPath = this.lockRepo.getRootPath();
            if (Files.exists(lockRepoRootPath, new LinkOption[0])) {
                MoreFiles.deleteRecursively((Path)lockRepoRootPath, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
            }
        }
        finally {
            if (Files.exists(this.txnBasePath, new LinkOption[0])) {
                MoreFiles.deleteRecursively((Path)this.txnBasePath, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
            }
        }
    }
}

