/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.aksw.commons.io.util.FileUtils;
import org.aksw.commons.txn.impl.FileSync;
import org.aksw.commons.txn.impl.PathDiffState;
import org.aksw.commons.txn.impl.PathState;
import org.apache.commons.lang3.ArrayUtils;

public class FileSyncImpl
implements FileSync {
    protected Path targetFile;
    protected Path newContentFile;
    protected Path newContentTmpFile;
    protected Path oldContentFile;
    protected boolean deleteTargetFileOnUpdateWithEmptyContent;
    public static final Pattern TO_BASENAME = Pattern.compile("(\\.sync\\.(tmp|old|new))$");

    public FileSyncImpl(Path targetFile, Path oldContentFile, Path newContentFile, boolean deleteTargetFileOnUpdateWithEmptyContent) {
        this.targetFile = targetFile;
        this.newContentFile = newContentFile;
        this.oldContentFile = oldContentFile;
        this.newContentTmpFile = newContentFile.resolveSibling(targetFile.getFileName().toString() + ".sync.tmp");
        this.deleteTargetFileOnUpdateWithEmptyContent = deleteTargetFileOnUpdateWithEmptyContent;
    }

    public static FileSyncImpl create(Path path, boolean deleteTargetFileOnUpdateWithEmptyContent) {
        String fileName = path.getFileName().toString();
        return new FileSyncImpl(path, path.resolveSibling(fileName + ".sync.old"), path.resolveSibling(fileName + ".sync.new"), deleteTargetFileOnUpdateWithEmptyContent);
    }

    public static String getBaseName(String str) {
        return TO_BASENAME.matcher(str).replaceAll("");
    }

    @Override
    public Path getTargetFile() {
        return this.targetFile;
    }

    @Override
    public Path getOldContentPath() {
        Path result = Files.exists(this.oldContentFile, new LinkOption[0]) ? this.oldContentFile : this.targetFile;
        return result;
    }

    @Override
    public Path getCurrentPath() {
        Path result = Files.exists(this.newContentFile, new LinkOption[0]) ? this.newContentFile : this.targetFile;
        return result;
    }

    @Override
    public InputStream openCurrentContent() throws IOException {
        Path currentPath = this.getCurrentPath();
        InputStream result = Files.newInputStream(currentPath, new OpenOption[0]);
        return result;
    }

    @Override
    public OutputStream newOutputStreamToNewTmpContent(boolean truncate) throws IOException {
        if (Files.isSymbolicLink(this.newContentFile)) {
            Files.deleteIfExists(this.newContentFile);
        }
        Object[] openOptions = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
        if (truncate) {
            openOptions = (OpenOption[])ArrayUtils.add((Object[])openOptions, (Object)StandardOpenOption.TRUNCATE_EXISTING);
        }
        Files.createDirectories(this.newContentTmpFile.getParent(), new FileAttribute[0]);
        OutputStream result = Files.newOutputStream(this.newContentTmpFile, (OpenOption[])openOptions);
        return result;
    }

    @Override
    public boolean exists() {
        Path currentPath = this.getCurrentPath();
        return Files.exists(currentPath, new LinkOption[0]);
    }

    @Override
    public Instant getLastModifiedTime() throws IOException {
        Instant result;
        Path currentPath = this.getCurrentPath();
        try {
            FileTime ft = Files.getLastModifiedTime(currentPath, new LinkOption[0]);
            result = ft.toInstant();
        }
        catch (NoSuchFileException e) {
            result = null;
        }
        return result;
    }

    @Override
    public synchronized void putContent(Consumer<OutputStream> outputStreamSupplier) throws IOException {
        Files.deleteIfExists(this.newContentFile);
        try (OutputStream out = this.newOutputStreamToNewTmpContent(true);){
            outputStreamSupplier.accept(out);
        }
        FileUtils.moveAtomic((Path)this.newContentTmpFile, (Path)this.newContentFile);
    }

    @Override
    public void preCommit() throws IOException {
        if (Files.exists(this.newContentTmpFile, new LinkOption[0])) {
            if (!Files.exists(this.oldContentFile, new LinkOption[0])) {
                if (!Files.exists(this.targetFile, new LinkOption[0])) {
                    Files.createDirectories(this.oldContentFile.getParent(), new FileAttribute[0]);
                    Files.createFile(this.oldContentFile, new FileAttribute[0]);
                } else {
                    FileUtils.moveAtomic((Path)this.targetFile, (Path)this.oldContentFile);
                }
            }
            FileUtils.moveAtomic((Path)this.newContentTmpFile, (Path)this.newContentFile);
        }
        if (Files.exists(this.newContentFile, new LinkOption[0])) {
            FileUtils.moveAtomic((Path)this.newContentFile, (Path)this.targetFile);
        }
    }

    @Override
    public void finalizeCommit() throws IOException {
        long size;
        Files.deleteIfExists(this.oldContentFile);
        if (Files.exists(this.targetFile, new LinkOption[0]) && (size = Files.size(this.targetFile)) == 0L && this.deleteTargetFileOnUpdateWithEmptyContent) {
            Files.deleteIfExists(this.targetFile);
        }
    }

    @Override
    public void rollback() throws IOException {
        Files.deleteIfExists(this.newContentFile);
        Files.deleteIfExists(this.newContentTmpFile);
        if (Files.exists(this.oldContentFile, new LinkOption[0])) {
            FileUtils.moveAtomic((Path)this.oldContentFile, (Path)this.targetFile);
        }
    }

    @Override
    public Path getNewContentTmpFile() {
        return this.newContentTmpFile;
    }

    public static Instant getLastModifiedTimeAsInstant(Path path) {
        Instant result = null;
        try {
            if (Files.exists(path, new LinkOption[0])) {
                FileTime timestamp = Files.getLastModifiedTime(path, new LinkOption[0]);
                if (timestamp == null) {
                    timestamp = FileTime.fromMillis(0L);
                }
                result = timestamp.toInstant();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static PathDiffState getState(FileSync fileSync) {
        Path originalSourcePath = fileSync.getOldContentPath();
        Path diffSourcePath = fileSync.getCurrentPath();
        Instant originalTimestamp = FileSyncImpl.getLastModifiedTimeAsInstant(originalSourcePath);
        Instant diffTimestamp = diffSourcePath == originalSourcePath ? originalTimestamp : FileSyncImpl.getLastModifiedTimeAsInstant(diffSourcePath);
        PathDiffState result = new PathDiffState(new PathState(originalSourcePath, originalTimestamp), new PathState(diffSourcePath, diffTimestamp));
        return result;
    }
}

