/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.api;

import java.io.IOException;
import java.time.Instant;
import org.aksw.commons.lock.db.api.ReadWriteLockWithOwnership;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.txn.impl.FileSync;
import org.aksw.commons.txn.impl.TxnComponent;

public interface TxnResourceApi
extends TxnComponent {
    public Path<String> getResourceKey();

    public ReadWriteLockWithOwnership getTxnResourceLock();

    public Instant getLastModifiedDate() throws IOException;

    public void declareAccess();

    public void undeclareAccess();

    public boolean isVisible();

    public FileSync getFileSync();

    default public void lock(boolean write) {
        ReadWriteLockWithOwnership txnResourceLock = this.getTxnResourceLock();
        if (write) {
            txnResourceLock.writeLock().lock();
        } else {
            txnResourceLock.readLock().lock();
        }
    }

    default public void unlock() {
        ReadWriteLockWithOwnership txnResourceLock = this.getTxnResourceLock();
        if (txnResourceLock.ownsReadLock()) {
            txnResourceLock.readLock().unlock();
        }
        if (txnResourceLock.ownsWriteLock()) {
            txnResourceLock.writeLock().unlock();
        }
    }
}

