/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.api;

import java.util.concurrent.Callable;

public interface TxnApi {
    public void begin(boolean var1);

    public void commit();

    public void abort();

    public static void execRead(TxnApi txn, Runnable runnable) {
        TxnApi.compute(txn, false, () -> {
            runnable.run();
            return null;
        });
    }

    public static void execWrite(TxnApi txn, Runnable runnable) {
        TxnApi.compute(txn, true, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T execRead(TxnApi txn, Callable<T> callable) {
        return TxnApi.compute(txn, false, callable);
    }

    public static <T> T execWrite(TxnApi txn, Callable<T> callable) {
        return TxnApi.compute(txn, true, callable);
    }

    public static <T> T compute(TxnApi txn, boolean isWrite, Callable<T> callable) {
        T result;
        txn.begin(isWrite);
        boolean success = false;
        try {
            result = callable.call();
            success = true;
        }
        catch (Exception e) {
            txn.abort();
            throw new RuntimeException(e);
        }
        if (success) {
            txn.commit();
        }
        return result;
    }
}

