/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.txn.api;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.stream.Stream;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.txn.api.TxnMgr;
import org.aksw.commons.txn.api.TxnResourceApi;

public interface Txn {
    public TxnMgr getTxnMgr();

    public String getId();

    public TxnResourceApi getResourceApi(Path<String> var1);

    public Stream<TxnResourceApi> listVisibleFiles(Path<String> var1);

    public Stream<Path<String>> streamAccessedResourcePaths() throws IOException;

    public boolean isStale() throws IOException;

    public boolean claim() throws IOException;

    public boolean isWrite();

    public void addCommit() throws IOException;

    public void addFinalize() throws IOException;

    public void addRollback() throws IOException;

    public boolean isCommit() throws IOException;

    public boolean isRollback() throws IOException;

    public boolean isFinalize() throws IOException;

    public void cleanUpTxn() throws IOException;

    public void promote();

    public Instant getCreationDate();

    public void updateHeartbeat() throws IOException;

    public Instant getMostRecentHeartbeat() throws IOException;

    public TemporalAmount getDurationToNextHeartbeat() throws IOException;

    public void setActivityDate(Instant var1) throws IOException;

    public Instant getActivityDate() throws IOException;

    default public Instant updateActivityDate() throws IOException {
        Instant now = Instant.now();
        this.setActivityDate(now);
        return now;
    }
}

