/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.lock.db.impl;

import java.time.Duration;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;
import org.aksw.commons.lock.LockBaseRepeat;
import org.aksw.commons.lock.db.api.ReadWriteLockWithOwnership;
import org.aksw.commons.lock.db.api.ResourceLock;
import org.aksw.commons.lock.db.impl.LockFromLink;
import org.aksw.commons.util.lock.LockUtils;

public class LockFromLockStore
implements ReadWriteLockWithOwnership {
    protected ResourceLock<String> resourceLock;
    protected Duration mgmtLockTtl = Duration.ofSeconds(10L);
    protected String ownerKey;
    protected LockFromLink mgmtLock;
    protected LockFromLink readLock;
    protected LockFromLink writeLock;
    protected Lock readLockView = new LockView(false);
    protected Lock writeLockView = new LockView(true);

    public LockFromLockStore(ResourceLock<String> resourceLock, String ownerKey, LockFromLink mgmtLock, LockFromLink readLock, LockFromLink writeLock) {
        this.resourceLock = resourceLock;
        this.ownerKey = ownerKey;
        this.mgmtLock = mgmtLock;
        this.readLock = readLock;
        this.writeLock = writeLock;
    }

    @Override
    public Lock readLock() {
        return this.readLockView;
    }

    @Override
    public Lock writeLock() {
        return this.writeLockView;
    }

    @Override
    public boolean ownsReadLock() {
        boolean result = this.readLock.isOwnedHere();
        return result;
    }

    @Override
    public boolean ownsWriteLock() {
        boolean result = this.writeLock.isOwnedHere();
        return result;
    }

    @Override
    public Lock getMgmtLock() {
        return this.mgmtLock;
    }

    public boolean checkIfLockingIsNeeded(boolean write) {
        boolean ownsR = this.ownsReadLock();
        boolean ownsW = this.ownsWriteLock();
        boolean needLock = true;
        if (ownsR) {
            if (write) {
                this.unlock();
            } else {
                needLock = false;
            }
        } else if (ownsW) {
            needLock = false;
        }
        return needLock;
    }

    protected boolean lock(boolean write) {
        return (Boolean)LockUtils.runWithMgmtLock((Lock)this.mgmtLock, LockFromLink::forceUnlock, (Duration)this.mgmtLockTtl, () -> this.lockCore(write));
    }

    protected boolean lockCore(boolean write) {
        boolean result;
        String writeLockOwnerKey = this.writeLock.readOwnerKey();
        if (writeLockOwnerKey != null && !this.ownerKey.equals(writeLockOwnerKey)) {
            throw new RuntimeException("Lock for " + this.ownerKey + " failed because write lock at " + String.valueOf(this.writeLock.getPath()) + " owned by " + writeLockOwnerKey);
        }
        if (!write) {
            result = this.readLock.singleLockAttempt();
        } else {
            boolean existsReadLock;
            try (Stream<String> stream = this.resourceLock.streamReadLockOwnerKeys();){
                existsReadLock = stream.findAny().isPresent();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (existsReadLock) {
                throw new RuntimeException("Read lock already exists next to " + String.valueOf(this.writeLock.getPath()));
            }
            result = this.writeLock.singleLockAttempt();
        }
        return result;
    }

    protected void unlock(boolean write) {
        LockUtils.runWithMgmtLock((Lock)this.mgmtLock, LockFromLink::forceUnlock, (Duration)this.mgmtLockTtl, () -> {
            this.unlockCore(write);
            return null;
        });
    }

    protected void unlockCore(boolean write) {
        if (write) {
            this.writeLock.unlock();
        } else {
            this.readLock.unlock();
        }
    }

    public void unlock() {
        this.readLock().unlock();
        this.writeLock().unlock();
    }

    public class LockView
    extends LockBaseRepeat {
        protected boolean write;

        public LockView(boolean write) {
            this.write = write;
        }

        @Override
        public boolean singleLockAttempt() throws InterruptedException {
            boolean r = LockFromLockStore.this.lock(this.write);
            return r;
        }

        @Override
        public void unlock() {
            LockFromLockStore.this.unlock(this.write);
        }
    }
}

