/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.lock.db.impl;

import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.function.Function;
import org.aksw.commons.io.util.FileUtils;
import org.aksw.commons.io.util.symlink.SymbolicLinkStrategy;
import org.aksw.commons.lock.LockBaseRepeat;
import org.aksw.commons.txn.impl.FileUtilsExtra;

public class LockFromLink
extends LockBaseRepeat {
    protected SymbolicLinkStrategy linkStrategy;
    protected Path path;
    protected String ownerKey;
    protected Function<String, Path> ownerKeyToTarget;
    protected Function<Path, String> targetToOwnerKey;
    protected Path cleanupAncestorPath;

    public LockFromLink(SymbolicLinkStrategy linkStrategy, Path path, String ownerKey, Function<String, Path> ownerKeyToTarget, Function<Path, String> targetToOwnerKey, Path cleanupAncestorPath) {
        this.linkStrategy = linkStrategy;
        this.path = path;
        this.ownerKey = ownerKey;
        this.ownerKeyToTarget = ownerKeyToTarget;
        this.targetToOwnerKey = targetToOwnerKey;
        this.cleanupAncestorPath = cleanupAncestorPath;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean singleLockAttempt() {
        boolean[] result = new boolean[]{false};
        try {
            FileUtilsExtra.ensureParentFolderExists(this.path, () -> {
                Path targetPath = this.ownerKeyToTarget.apply(this.ownerKey);
                try {
                    this.linkStrategy.createSymbolicLink(this.path, targetPath);
                    result[0] = true;
                }
                catch (FileAlreadyExistsException e) {
                    String currentOwnerKey = this.readOwnerKey();
                    if (this.ownerKey.equals(currentOwnerKey)) {
                        result[0] = true;
                    }
                    throw new RuntimeException("Cannot acquire lock at " + String.valueOf(targetPath) + " for owner " + this.ownerKey + " because it is owned by '" + currentOwnerKey + "'");
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result[0];
    }

    @Override
    public void unlock() {
        String currentOwnerKey = this.readOwnerKey();
        if (currentOwnerKey != null) {
            if (!this.ownerKey.equals(currentOwnerKey)) {
                throw new RuntimeException("Cannot unlock a lock with owner " + this.ownerKey + " because it is owned by " + currentOwnerKey);
            }
            this.forceUnlock();
        }
    }

    public boolean forceUnlock() {
        try {
            boolean result = FileUtils.deleteFileIfExistsAndThenDeleteEmptyFolders((Path)this.path, (Path)this.cleanupAncestorPath, (boolean)true);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String readOwnerKey() {
        String result;
        try {
            Path target = this.linkStrategy.readSymbolicLink(this.path);
            result = this.targetToOwnerKey.apply(target);
        }
        catch (NoSuchFileException e) {
            result = null;
        }
        catch (AccessDeniedException e) {
            result = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public boolean isOwnedHere() {
        String currentOwnerKey = this.readOwnerKey();
        boolean result = this.ownerKey.equals(currentOwnerKey);
        return result;
    }

    public String toString() {
        return "LockFromLink [path=" + String.valueOf(this.path) + "]";
    }
}

