/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.lock;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;
import org.aksw.commons.lock.LockManager;
import org.aksw.commons.lock.ProcessFileLock;
import org.aksw.commons.util.exception.ExceptionUtilsAksw;

public class LockManagerPath
implements LockManager<Path> {
    protected Path basePath;
    protected Map<Path, ProcessFileLock> pathToLock = new ConcurrentHashMap<Path, ProcessFileLock>();

    public LockManagerPath(Path basePath) {
        this.basePath = basePath;
    }

    @Override
    public Lock getLock(Path path, boolean write) {
        Path absPath = this.basePath.resolve(path);
        Path relPath = this.basePath.relativize(absPath);
        return this.pathToLock.computeIfAbsent(relPath, p -> new ProcessFileLock(absPath));
    }

    public static boolean tryCreateFile(Path path) {
        boolean result = false;
        Path parentPath = path.getParent();
        if (parentPath != null) {
            try {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        try {
            Files.createFile(path, new FileAttribute[0]);
            result = true;
        }
        catch (IOException e) {
            ExceptionUtilsAksw.rethrowUnless((Throwable)e, (Predicate[])new Predicate[]{ExceptionUtilsAksw.isRootCauseInstanceOf(FileAlreadyExistsException.class)});
        }
        return result;
    }
}

