/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.lock;

import java.util.concurrent.TimeUnit;
import org.aksw.commons.lock.LockBase;
import org.aksw.commons.util.retry.RetryUtils;

public abstract class LockBaseRepeat
extends LockBase {
    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.tryLockActual(time, unit);
    }

    protected boolean tryLockActual(long time, TimeUnit unit) throws InterruptedException {
        long ms = unit.toMillis(time);
        long retryIntervalInMs = 100L;
        long retryCount = ms / retryIntervalInMs + (long)(ms % retryIntervalInMs == 0L ? 0 : 1);
        boolean result = (Boolean)RetryUtils.simpleRetry((long)retryCount, (long)retryIntervalInMs, () -> {
            boolean r = this.singleLockAttempt();
            return r;
        });
        return result;
    }

    protected abstract boolean singleLockAttempt() throws InterruptedException;
}

