/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.lock;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.aksw.commons.lock.LockBase;

public class CompoundLock
extends LockBase {
    protected List<? extends Lock> locks;
    protected int heldLocks = 0;

    public CompoundLock(List<? extends Lock> locks) {
        if (locks.isEmpty()) {
            throw new IllegalArgumentException("The set of locks must not be empty");
        }
        this.locks = locks;
        this.heldLocks = 0;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        long startTime = System.nanoTime();
        long allowedTime = TimeUnit.NANOSECONDS.convert(time, unit);
        try {
            for (int i = 0; i < this.locks.size(); ++i) {
                boolean isLastLock = i + 1 == this.locks.size();
                Lock lock = this.locks.get(i);
                boolean success = lock.tryLock(time, unit);
                ++this.heldLocks;
                long elapsedTime = System.nanoTime() - startTime;
                if (success && (elapsedTime <= allowedTime || isLastLock)) continue;
                this.unlock();
                break;
            }
        }
        catch (Exception e) {
            this.unlock();
        }
        boolean result = this.heldLocks == this.locks.size();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        CompoundLock compoundLock = this;
        synchronized (compoundLock) {
            for (int i = this.heldLocks - 1; i >= 0; --i) {
                Lock lock = this.locks.get(i);
                lock.unlock();
            }
            this.heldLocks = 0;
        }
    }
}

