/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.tuple.finder;

import java.util.stream.Stream;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;

public interface TupleFinder<D, C> {
    public TupleBridge<D, C> getTupleBridge();

    public <X> Stream<D> find(X var1, TupleAccessor<? super X, ? extends C> var2);

    default public Stream<D> find(D tuple) {
        return this.find((Object)tuple, (TupleAccessor)this.getTupleBridge());
    }

    default public int getDimension() {
        return this.getTupleBridge().getDimension();
    }

    default public <X> boolean contains(X tuple, TupleAccessor<? super X, ? extends C> accessor) {
        boolean result;
        try (Stream<D> stream = this.find(tuple, accessor);){
            result = stream.findFirst().isPresent();
        }
        return result;
    }

    default public Stream<D> find(C ... args) {
        return this.find((Object)args, (TupleAccessor)(arg, i) -> args[i]);
    }

    default public boolean contains(C ... args) {
        return this.contains((Object)args, (TupleAccessor)(arg, i) -> args[i]);
    }
}

