/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.tuple.query;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.aksw.commons.tuple.query.TupleQuery;
import org.apache.commons.lang3.ArrayUtils;

public class TupleQueryImpl<ComponentType>
implements TupleQuery<ComponentType> {
    protected int dimension;
    protected List<ComponentType> pattern;
    protected boolean distinct = false;
    protected int[] projection = null;

    public static <T> List<T> listOfNulls(int size) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            result.add(null);
        }
        return result;
    }

    public TupleQueryImpl(int dimension) {
        this.dimension = dimension;
        this.pattern = TupleQueryImpl.listOfNulls(dimension);
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public TupleQuery<ComponentType> setDistinct(boolean onOrOff) {
        this.distinct = onOrOff;
        return this;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public TupleQuery<ComponentType> setConstraint(int idx, ComponentType value) {
        this.pattern.set(idx, value);
        return this;
    }

    @Override
    public ComponentType getConstraint(int idx) {
        return this.pattern.get(idx);
    }

    @Override
    public int[] getProject() {
        return this.projection;
    }

    @Override
    public TupleQuery<ComponentType> clearProject() {
        this.projection = null;
        return this;
    }

    @Override
    public List<ComponentType> getPattern() {
        return this.pattern;
    }

    @Override
    public TupleQuery<ComponentType> setProject(int ... tupleIdxs) {
        this.projection = tupleIdxs;
        return this;
    }

    @Override
    public boolean hasProject() {
        return this.projection != null;
    }

    @Override
    public Set<Integer> getConstrainedComponents() {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (int i = 0; i < this.dimension; ++i) {
            ComponentType value = this.getConstraint(i);
            if (value == null) continue;
            result.add(i);
        }
        return result;
    }

    public String toString() {
        String result = "SELECT " + (this.isDistinct() ? "DISTINCT " : "") + (this.projection == null ? "*" : IntStream.of(this.projection).mapToObj(Integer::toString).collect(Collectors.joining(" "))) + " WHERE " + (this.getConstrainedComponents().isEmpty() ? "TRUE" : this.getConstrainedComponents().stream().map(idx -> idx + "=" + String.valueOf(this.getConstraint((int)idx))).collect(Collectors.joining(" AND ")));
        return result;
    }

    @Override
    public TupleQuery<ComponentType> addProject(int ... tupleIdxs) {
        this.projection = ArrayUtils.addAll((int[])this.projection, (int[])tupleIdxs);
        return this;
    }
}

