/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.tuple.bridge;

import org.aksw.commons.tuple.accessor.TupleAccessor;

public interface TupleBridge<D, C>
extends TupleAccessor<D, C> {
    public int getDimension();

    public <T> D build(T var1, TupleAccessor<? super T, ? extends C> var2);

    default public D build(C ... components) {
        return this.build((Object)components, (TupleAccessor)(cs, i) -> cs[i]);
    }

    default public void validateBuildArg(TupleBridge<?, ?> bridge) {
        int r;
        int cl = bridge.getDimension();
        if (cl != (r = this.getDimension())) {
            throw new IllegalArgumentException("components.length must equal dimension but " + cl + " != " + r);
        }
    }

    default public Object compact(D domainObject) {
        D result = this.getDimension() == 1 ? this.get(domainObject, 0) : domainObject;
        return result;
    }

    default public C[] toComponentArray(D domainObject) {
        int len = this.getDimension();
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.get(domainObject, i);
        }
        return result;
    }
}

