/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.util;

import io.reactivex.rxjava3.core.Flowable;
import java.util.Iterator;
import org.aksw.commons.accessors.SingleValuedAccessorDirect;
import org.aksw.commons.lambda.throwing.ThrowingBiConsumer;
import org.aksw.commons.lambda.throwing.ThrowingConsumer;
import org.aksw.commons.lambda.throwing.ThrowingFunction;
import org.aksw.commons.lambda.throwing.ThrowingSupplier;

public class FlowableEx {
    public static <T, I extends Iterator<T>> Flowable<T> fromIteratorSupplier(ThrowingSupplier<I> itSupp, ThrowingConsumer<? super I> closer) {
        return Flowable.generate(() -> itSupp.get(), (it, e) -> {
            try {
                if (it.hasNext()) {
                    Object item = it.next();
                    e.onNext(item);
                } else {
                    e.onComplete();
                }
            }
            catch (Exception x) {
                e.onError((Throwable)x);
            }
        }, it -> {
            if (closer != null) {
                closer.accept(it);
            }
        });
    }

    public static <T, I extends Iterator<T>> Flowable<T> fromIteratorSupplierLazyInit(ThrowingSupplier<I> itSupp, ThrowingConsumer<? super I> closer) {
        return Flowable.generate(() -> new SingleValuedAccessorDirect(), (itHolder, e) -> {
            try {
                Iterator it = (Iterator)itHolder.get();
                if (it == null) {
                    it = (Iterator)itSupp.get();
                    itHolder.set((Object)it);
                }
                if (it.hasNext()) {
                    Object item = it.next();
                    e.onNext(item);
                } else {
                    e.onComplete();
                }
            }
            catch (Exception x) {
                e.onError((Throwable)x);
            }
        }, itHolder -> {
            Iterator it;
            if (closer != null && (it = (Iterator)itHolder.get()) != null) {
                closer.accept((Object)it);
            }
        });
    }

    public static <T, R, C> Flowable<T> fromIterableResource(ThrowingSupplier<R> resourceSupplier, ThrowingFunction<? super R, C> toIterable, ThrowingFunction<? super C, ? extends Iterator<T>> toIterator, ThrowingBiConsumer<? super R, ? super C> closer) {
        Flowable result = Flowable.generate(() -> new IterableResourceState(resourceSupplier.get()), (state, emitter) -> {
            try {
                Iterator iterator = state.iterator;
                if (iterator == null) {
                    Object iterable = toIterable.apply(state.resource);
                    iterator = state.iterator = (Iterator)toIterator.apply(iterable);
                }
                if (iterator.hasNext()) {
                    Object item = iterator.next();
                    emitter.onNext(item);
                } else {
                    emitter.onComplete();
                }
            }
            catch (Exception e) {
                emitter.onError((Throwable)e);
            }
        }, state -> closer.accept(state.resource, state.iterable));
        return result;
    }

    public static <T, R, E> Flowable<T> fromEnumerableResource(ThrowingSupplier<R> resourceSupplier, ThrowingFunction<? super R, E> toEnumerable, ThrowingFunction<? super E, T> nextRecord, ThrowingBiConsumer<? super R, ? super E> closer) {
        Flowable result = Flowable.generate(() -> new IterableResourceState(resourceSupplier.get()), (state, emitter) -> {
            try {
                Object record;
                Object enumerable = state.iterable;
                if (enumerable == null) {
                    enumerable = state.iterable = toEnumerable.apply(state.resource);
                }
                if ((record = nextRecord.apply(enumerable)) != null) {
                    emitter.onNext(record);
                } else {
                    emitter.onComplete();
                }
            }
            catch (Exception e) {
                emitter.onError((Throwable)e);
            }
        }, state -> closer.accept(state.resource, state.iterable));
        return result;
    }

    private static class IterableResourceState<R, C, T> {
        R resource;
        C iterable;
        Iterator<T> iterator;

        public IterableResourceState(R resource) {
            this.resource = resource;
        }
    }
}

