/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.op;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.parallel.ParallelTransformer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.LongStream;
import org.aksw.commons.rx.op.OperatorLocalOrder;

public class RxOps {
    public static <I, O> Iterator<O> transform(Iterator<I> it, FlowableTransformer<? super I, O> transformer) {
        return Flowable.fromIterable(() -> it).compose(transformer).blockingIterable().iterator();
    }

    public static <I, O> FlowableTransformer<I, O> createParallelMapperOrderedCore(ParallelTransformer<Map.Entry<I, Long>, Map.Entry<O, Long>> parallelTransformer) {
        return in -> in.zipWith(() -> LongStream.iterate(0L, i -> i + 1L).iterator(), (k, v) -> new AbstractMap.SimpleEntry<Object, Long>(k, (Long)v)).parallel().runOn(Schedulers.io()).compose(parallelTransformer).sequential().lift((FlowableOperator)OperatorLocalOrder.forLong((long)0L, Map.Entry::getValue)).map(Map.Entry::getKey);
    }

    public static <I, O> FlowableTransformer<I, O> createParallelMapperOrdered(Function<? super I, O> mapper) {
        return RxOps.createParallelMapperOrderedCore(in -> in.map(e -> {
            Object before = e.getKey();
            Object after = mapper.apply((Object)before);
            AbstractMap.SimpleEntry r = new AbstractMap.SimpleEntry(after, (Long)e.getValue());
            return r;
        }));
    }

    public static <I, O> FlowableTransformer<I, O> createParallelFlatMapperOrdered(Function<? super I, ? extends Iterable<? extends O>> mapper) {
        return in -> in.compose(RxOps.createParallelMapperOrdered(mapper)).concatMap(Flowable::fromIterable);
    }
}

