/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.lookup;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Map;
import org.aksw.commons.rx.lookup.LookupService;

public class LookupServicePartition<K, V>
implements LookupService<K, V> {
    private LookupService<K, V> base;
    private int partitionSize;
    private int nThreads;

    public LookupServicePartition(LookupService<K, V> base, int partitionSize) {
        this(base, partitionSize, 1);
    }

    public LookupServicePartition(LookupService<K, V> base, int partitionSize, int nThreads) {
        this.base = base;
        this.partitionSize = partitionSize;
        this.nThreads = nThreads;
    }

    @Override
    public Flowable<Map.Entry<K, V>> apply(Iterable<K> keys) {
        return Flowable.fromIterable(keys).buffer(this.partitionSize).parallel(this.nThreads).runOn(Schedulers.io()).flatMap(this.base::apply).sequential();
    }

    public static <K, V> LookupServicePartition<K, V> create(LookupService<K, V> base, int partitionSize) {
        LookupServicePartition<K, V> result = new LookupServicePartition<K, V>(base, partitionSize);
        return result;
    }

    public static <K, V> LookupServicePartition<K, V> create(LookupService<K, V> base, int partitionSize, int nThreads) {
        LookupServicePartition<K, V> result = new LookupServicePartition<K, V>(base, partitionSize, nThreads);
        return result;
    }
}

