/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.lookup;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.reactivex.rxjava3.core.Flowable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.aksw.commons.rx.lookup.LookupService;

public class LookupServiceCacheMem<K, V>
implements LookupService<K, V> {
    protected Cache<K, Optional<V>> hitCache;
    protected Cache<K, Object> missCache;
    private LookupService<K, V> base;

    public LookupServiceCacheMem(LookupService<K, V> base) {
        this(base, 10000L);
    }

    public LookupServiceCacheMem(LookupService<K, V> base, long maxCacheSize) {
        this(base, CacheBuilder.newBuilder().maximumSize(maxCacheSize).build(), CacheBuilder.newBuilder().maximumSize(maxCacheSize).build());
    }

    public LookupServiceCacheMem(LookupService<K, V> base, Cache<K, Optional<V>> cache, Cache<K, Object> missCache) {
        this.base = base;
        this.hitCache = cache;
        this.missCache = missCache;
    }

    @Override
    public Map<K, V> fetchMap(Iterable<K> keys) {
        LinkedHashSet lookupKeys = Sets.newLinkedHashSet(keys);
        ImmutableMap cachedEntries = this.hitCache.getAllPresent(keys);
        lookupKeys.removeAll(cachedEntries.keySet());
        LinkedHashSet knownMissKeys = new LinkedHashSet(Sets.intersection((Set)lookupKeys, this.missCache.asMap().keySet()));
        lookupKeys.removeAll(knownMissKeys);
        Map<K, V> fetchedMap = this.base.fetchMap(lookupKeys);
        LinkedHashMap<K, Object> result = new LinkedHashMap<K, Object>();
        for (K key : keys) {
            Object value;
            if (cachedEntries.containsKey(key)) {
                value = ((Optional)cachedEntries.get(key)).orElse(null);
                this.hitCache.put(key, Optional.ofNullable(value));
                result.put(key, value);
                continue;
            }
            if (fetchedMap.containsKey(key)) {
                value = fetchedMap.get(key);
                this.hitCache.put(key, Optional.ofNullable(value));
                result.put(key, value);
                continue;
            }
            this.missCache.put(key, (Object)true);
        }
        return result;
    }

    @Override
    public Flowable<Map.Entry<K, V>> apply(Iterable<K> keys) {
        Map<K, V> map = this.fetchMap(keys);
        Flowable result = Flowable.fromIterable(map.entrySet());
        return result;
    }

    public static <K, V> LookupServiceCacheMem<K, V> create(LookupService<K, V> base) {
        LookupServiceCacheMem<K, V> result = new LookupServiceCacheMem<K, V>(base);
        return result;
    }

    public static <K, V> LookupServiceCacheMem<K, V> create(LookupService<K, V> base, int maxCacheSize) {
        LookupServiceCacheMem<K, V> result = new LookupServiceCacheMem<K, V>(base, maxCacheSize);
        return result;
    }

    public static <K, V> LookupServiceCacheMem<K, V> create(LookupService<K, V> base, Cache<K, Optional<V>> hitCache, Cache<K, Object> missCache) {
        LookupServiceCacheMem<K, V> result = new LookupServiceCacheMem<K, V>(base, hitCache, missCache);
        return result;
    }
}

