/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.lookup;

import com.google.common.cache.Cache;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aksw.commons.rx.lookup.LookupServiceAddAbsentKeys;
import org.aksw.commons.rx.lookup.LookupServiceCacheMem;
import org.aksw.commons.rx.lookup.LookupServiceFilterKey;
import org.aksw.commons.rx.lookup.LookupServicePartition;
import org.aksw.commons.rx.lookup.LookupServiceTransformKey;
import org.aksw.commons.rx.lookup.LookupServiceTransformValue;

public interface LookupService<K, V>
extends Function<Iterable<K>, Flowable<Map.Entry<K, V>>> {
    default public V fetchItem(K k) {
        return this.fetchMap(Collections.singleton(k)).get(k);
    }

    default public LookupService<K, V> partition(int k) {
        return LookupServicePartition.create(this, k);
    }

    default public LookupService<K, V> filterKeys(Predicate<? super K> filter) {
        return LookupServiceFilterKey.create(this, filter);
    }

    default public <W> LookupService<K, W> mapValues(Function<V, W> fn) {
        return LookupServiceTransformValue.create(this, fn);
    }

    default public <W> LookupService<K, W> mapNonNullValues(Function<V, W> fn) {
        return this.mapValues((V x) -> x == null ? null : fn.apply(x));
    }

    default public <W> LookupService<K, W> mapValues(BiFunction<K, V, W> fn) {
        return LookupServiceTransformValue.create(this, fn);
    }

    default public <W> LookupService<K, W> mapNonNullValues(BiFunction<K, V, W> fn) {
        return this.mapValues((K k, V v) -> v == null ? null : fn.apply(k, v));
    }

    default public <I> LookupService<I, V> mapKeys(Function<? super I, ? extends K> fn) {
        return LookupServiceTransformKey.create(this, fn);
    }

    default public LookupService<K, V> defaultForAbsentKeys(Function<? super K, ? extends V> defaultValueGenerator) {
        return new LookupServiceAddAbsentKeys<K, V>(this, defaultValueGenerator);
    }

    default public LookupService<K, V> cache() {
        return LookupServiceCacheMem.create(this);
    }

    default public LookupService<K, V> cache(Cache<K, Optional<V>> hitCache, Cache<K, Object> missCache) {
        return LookupServiceCacheMem.create(this, hitCache, missCache);
    }

    default public Single<Map<K, V>> requestMap(Iterable<K> keys) {
        Single result = ((Flowable)this.apply(keys)).toMap(Map.Entry::getKey, Map.Entry::getValue);
        return result;
    }

    default public Map<K, V> fetchMap(Iterable<K> keys) {
        Map result = (Map)this.requestMap(keys).blockingGet();
        return result;
    }

    default public Single<List<V>> requestList(Iterable<K> keys) {
        Single result = ((Flowable)this.apply(keys)).map(Map.Entry::getValue).toList();
        return result;
    }

    default public List<V> fetchList(Iterable<K> keys) {
        List result = (List)this.requestList(keys).blockingGet();
        return result;
    }

    default public <X> Map<X, V> fetchMap(Iterable<X> keys, Function<? super X, ? extends K> keyMapper) {
        Map<? super X, V> result = this.mapKeys(keyMapper).fetchMap(keys);
        return result;
    }
}

