/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.lookup;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.primitives.Ints;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.aksw.commons.rx.lookup.ListPaginator;
import org.aksw.commons.rx.lookup.ListService;

public class ListServiceFromList<C, T>
implements ListService<C, T> {
    protected List<T> items;
    protected BiPredicate<C, T> predicate;

    public ListServiceFromList(List<T> items, BiPredicate<C, T> predicate) {
        this.items = items;
        this.predicate = predicate;
    }

    public static <C, T> ListService<C, T> wrap(List<T> items, BiPredicate<C, T> predicate) {
        return new ListServiceFromList<C, T>(items, predicate);
    }

    @Override
    public ListPaginator<T> createPaginator(C concept) {
        return new ListPaginatorList(concept);
    }

    public class ListPaginatorList
    implements ListPaginator<T> {
        protected C concept;

        public ListPaginatorList(C concept) {
            this.concept = concept;
        }

        protected Stream<T> createFilteredList(C concept) {
            return ListServiceFromList.this.items.stream().filter(item -> ListServiceFromList.this.predicate.test(concept, item));
        }

        @Override
        public Flowable<T> apply(Range<Long> t) {
            ContiguousSet set = ContiguousSet.create(t, (DiscreteDomain)DiscreteDomain.longs());
            int fromIndex = Ints.saturatedCast((long)((Long)set.first()));
            int toIndex = Ints.saturatedCast((long)((Long)set.last()));
            Stream stream = this.createFilteredList(this.concept).skip(fromIndex).limit(toIndex);
            return Flowable.fromStream(stream);
        }

        @Override
        public Single<Range<Long>> fetchCount(Long itemLimit, Long rowLimit) {
            long count = this.createFilteredList(this.concept).count();
            return Single.just((Object)Range.closedOpen((Comparable)Long.valueOf(count), (Comparable)Long.valueOf(count)));
        }
    }
}

