/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.io;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.IOException;
import java.util.Iterator;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.util.closeable.AutoCloseableWithLeakDetectionBase;

public class SequentialReaderRx<A>
extends AutoCloseableWithLeakDetectionBase
implements ReadableChannel<A> {
    protected Flowable<?> flowable;
    protected ArrayOps<A> arrayOps;
    protected Iterator<?> iterator = null;
    protected Disposable disposable;

    public SequentialReaderRx(Flowable<?> flowable, ArrayOps<A> arrayOps) {
        this.flowable = flowable;
        this.arrayOps = arrayOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.iterator == null) {
            SequentialReaderRx sequentialReaderRx = this;
            synchronized (sequentialReaderRx) {
                if (this.iterator == null) {
                    this.ensureOpen();
                    this.iterator = this.flowable.blockingIterable().iterator();
                    this.disposable = (Disposable)this.iterator;
                }
            }
        }
    }

    public boolean isStarted() {
        return this.iterator != null;
    }

    public void closeActual() throws IOException {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }

    public int read(A array, int position, int length) throws IOException {
        int i;
        this.ensureOpen();
        if (!this.isStarted()) {
            this.start();
        }
        for (i = 0; i < length && this.iterator.hasNext(); ++i) {
            Object value = this.iterator.next();
            this.arrayOps.set(array, position + i, value);
        }
        return i == 0 ? -1 : i;
    }

    public ArrayOps<A> getArrayOps() {
        return this.arrayOps;
    }

    public boolean isOpen() {
        return !this.isClosed;
    }
}

