/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.cache.range;

import com.google.common.collect.Range;
import com.google.common.primitives.Ints;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import org.aksw.commons.rx.lookup.ListPaginator;
import org.aksw.commons.rx.range.RangedSupplier;
import org.aksw.commons.rx.range.RangedSupplierDelegated;
import org.aksw.commons.util.range.RangeUtils;

public class ListPaginatorWithSimpleCache<T>
extends RangedSupplierDelegated<Long, T>
implements ListPaginator<T> {
    protected Single<List<T>> cache = Single.fromCallable(() -> (List)((Flowable)delegate.apply(Range.atLeast((Comparable)Long.valueOf(0L)))).toList().blockingGet()).cache();

    public ListPaginatorWithSimpleCache(RangedSupplier<Long, T> delegate) {
        super(delegate);
    }

    @Override
    public Single<Range<Long>> fetchCount(Long itemLimit, Long rowLimit) {
        return this.cache.map(list -> Range.lessThan((Comparable)Long.valueOf(list.size())));
    }

    @Override
    public Flowable<T> apply(Range<Long> range) {
        Range r = RangeUtils.map(range, Ints::checkedCast);
        return this.cache.map(list -> RangeUtils.subList((List)list, (Range)r)).toFlowable().flatMap(Flowable::fromIterable);
    }

    public static <V> ListPaginator<V> wrap(ListPaginator<V> backend) {
        return new ListPaginatorWithSimpleCache(backend);
    }
}

