/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.playground;

import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import org.aksw.commons.rx.op.LocalOrderSpec;
import org.aksw.commons.rx.op.OperatorLocalOrder;

class MyPublisher<T, S extends Comparable<S>> {
    protected PublishSubject<T> publishSubject = PublishSubject.create();
    protected LocalOrderSpec<T, S> orderSpec;

    public MyPublisher(LocalOrderSpec<T, S> orderSpec) {
        this.orderSpec = orderSpec;
    }

    public static <T, S extends Comparable<S>> MyPublisher<T, S> create(LocalOrderSpec<T, S> orderSpec) {
        return new MyPublisher<T, S>(orderSpec);
    }

    public void offer(T item) {
        this.publishSubject.onNext(item);
    }

    public Flowable<T> createFlow(S start) {
        return this.publishSubject.toFlowable(BackpressureStrategy.ERROR).filter(item -> ((Number)this.orderSpec.getDistanceFn().apply(start, this.orderSpec.getExtractSeqId().apply(item))).longValue() > 0L).lift(OperatorLocalOrder.create(start, this.orderSpec));
    }
}

