/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.lookup;

import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Function;
import org.aksw.commons.rx.lookup.ListPaginator;
import org.aksw.commons.rx.lookup.ListService;
import org.aksw.commons.rx.lookup.LookupService;
import org.aksw.commons.rx.lookup.LookupServiceFromMapService;
import org.aksw.commons.rx.lookup.MapPaginator;
import org.aksw.commons.rx.lookup.MapService;

public class MapServiceFromListService<C, T, K, V>
implements MapService<C, K, V> {
    protected ListService<C, T> listService;
    protected Function<? super T, ? extends K> itemToKey;
    protected Function<? super T, ? extends V> itemToValue;

    public MapServiceFromListService(ListService<C, T> listService, Function<? super T, ? extends K> itemToKey, Function<? super T, ? extends V> itemToValue) {
        this.listService = listService;
        this.itemToKey = itemToKey;
        this.itemToValue = itemToValue;
    }

    @Override
    public MapPaginator<K, V> createPaginator(C concept) {
        ListPaginator<T> listPaginator = this.listService.createPaginator(concept);
        return new MapPaginatorFromListService(listPaginator);
    }

    public LookupService<K, V> asLookupService(Function<? super Iterable<? extends K>, C> keysToFilter) {
        LookupServiceFromMapService result = new LookupServiceFromMapService(this, keysToFilter);
        return result;
    }

    public class MapPaginatorFromListService
    implements MapPaginator<K, V> {
        protected ListPaginator<T> listPaginator;

        public MapPaginatorFromListService(ListPaginator<T> listPaginator) {
            this.listPaginator = listPaginator;
        }

        @Override
        public Flowable<Map.Entry<K, V>> apply(Range<Long> t) {
            Flowable result = ((Flowable)this.listPaginator.apply(t)).map(item -> {
                Object key = MapServiceFromListService.this.itemToKey.apply(item);
                Object value = MapServiceFromListService.this.itemToValue.apply(item);
                AbstractMap.SimpleEntry r = new AbstractMap.SimpleEntry(key, value);
                return r;
            });
            return result;
        }

        @Override
        public Single<Range<Long>> fetchCount(Long itemLimit, Long rowLimit) {
            return this.listPaginator.fetchCount(itemLimit, rowLimit);
        }
    }
}

