/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.lookup;

import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Single;
import java.util.Map;
import java.util.function.BiFunction;
import org.aksw.commons.rx.lookup.ListService;
import org.aksw.commons.rx.lookup.MapPaginator;
import org.aksw.commons.rx.lookup.MapServiceTransformItem;
import org.aksw.commons.util.range.RangeUtils;

public interface MapService<C, K, V>
extends ListService<C, Map.Entry<K, V>> {
    public MapPaginator<K, V> createPaginator(C var1);

    default public Map<K, V> fetchData(C concept, Range<Long> range) {
        Map result = this.createPaginator((Object)concept).fetchMap(range);
        return result;
    }

    default public Map<K, V> fetchData(C concept) {
        Map<K, V> result = this.fetchData(concept, (Range<Long>)RangeUtils.rangeStartingWithZero);
        return result;
    }

    default public Single<Range<Long>> fetchCount(C concept, Long itemLimit, Long rowLimit) {
        Single result = this.createPaginator((Object)concept).fetchCount(itemLimit, rowLimit);
        return result;
    }

    default public Single<Long> fetchCount() {
        return this.fetchCount(null, null, null).map(Range::lowerEndpoint);
    }

    default public Map<K, V> fetchData(C concept, Long limit, Long offset) {
        Range range = RangeUtils.createRange((Long)limit, (Long)offset);
        Map<K, V> result = this.fetchData(concept, (Range<Long>)range);
        return result;
    }

    default public <O> MapService<C, K, O> transformValues(BiFunction<? super K, ? super V, ? extends O> transform) {
        return new MapServiceTransformItem(this, transform);
    }
}

