/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.lookup;

import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.Map;
import java.util.function.BiFunction;
import org.aksw.commons.rx.lookup.MapPaginator;

public class MapPaginatorTransformItem<K, I, O>
implements MapPaginator<K, O> {
    protected MapPaginator<K, I> delegate;
    protected BiFunction<? super K, ? super I, ? extends O> fnTransformItem;

    public MapPaginatorTransformItem(MapPaginator<K, I> delegate, BiFunction<? super K, ? super I, ? extends O> fnTransformItem) {
        this.delegate = delegate;
        this.fnTransformItem = fnTransformItem;
    }

    @Override
    public Flowable<Map.Entry<K, O>> apply(Range<Long> range) {
        return ((Flowable)this.delegate.apply(range)).map(e -> Maps.immutableEntry(e.getKey(), this.fnTransformItem.apply(e.getKey(), e.getValue())));
    }

    @Override
    public Single<Range<Long>> fetchCount(Long itemLimit, Long rowLimit) {
        Single result = this.delegate.fetchCount(itemLimit, rowLimit);
        return result;
    }

    public static <K, I, O> MapPaginatorTransformItem<K, I, O> create(MapPaginator<K, I> listService, BiFunction<? super K, ? super I, ? extends O> fnTransformItem) {
        MapPaginatorTransformItem<? super K, ? super I, ? extends O> result = new MapPaginatorTransformItem<K, I, O>(listService, fnTransformItem);
        return result;
    }
}

