/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.lookup;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Map;
import org.aksw.commons.rx.lookup.LookupService;

public class LookupServiceTransformKey2<KI, KO, V>
implements LookupService<KI, V> {
    private LookupService<KO, V> delegate;
    private Function<? super KI, KO> to;
    private Function<? super Map.Entry<KO, V>, KI> from;

    public LookupServiceTransformKey2(LookupService<KO, V> delegate, Function<? super KI, KO> to, Function<? super Map.Entry<KO, V>, KI> from) {
        this.delegate = delegate;
        this.to = to;
        this.from = from;
    }

    @Override
    public Flowable<Map.Entry<KI, V>> apply(Iterable<KI> keys) {
        Iterable kos = Iterables.transform(keys, this.to);
        Flowable tmp = (Flowable)this.delegate.apply(kos);
        Flowable result = tmp.map(entry -> {
            Object ki = this.from.apply(entry);
            Object v = entry.getValue();
            return Maps.immutableEntry((Object)ki, v);
        });
        return result;
    }

    public static <KI, KO, V> LookupServiceTransformKey2<KI, KO, V> create(LookupService<KO, V> delegate, Function<? super KI, KO> to, Function<? super Map.Entry<KO, V>, KI> from) {
        LookupServiceTransformKey2<? super KI, KO, V> result = new LookupServiceTransformKey2<KI, KO, V>(delegate, to, from);
        return result;
    }
}

