/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.lookup;

import io.reactivex.rxjava3.core.Flowable;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.aksw.commons.rx.lookup.LookupService;

public class LookupServiceTransformKey<KI, KO, V>
implements LookupService<KI, V> {
    private LookupService<KO, V> delegate;
    private Function<? super KI, ? extends KO> keyMapper;

    public LookupServiceTransformKey(LookupService<KO, V> delegate, Function<? super KI, ? extends KO> keyMapper) {
        this.delegate = delegate;
        this.keyMapper = keyMapper;
    }

    @Override
    public Flowable<Map.Entry<KI, V>> apply(Iterable<KI> keys) {
        LinkedHashMap keyMap = new LinkedHashMap();
        for (KI ki : keys) {
            KO ko = this.keyMapper.apply(ki);
            keyMap.put(ko, ki);
        }
        Flowable tmp = (Flowable)this.delegate.apply(keyMap.keySet());
        Flowable result = tmp.map(entry -> {
            Object ko = entry.getKey();
            Object v = entry.getValue();
            boolean isMapped = keyMap.containsKey(ko);
            if (!isMapped) {
                throw new RuntimeException("should not happen");
            }
            Object ki = keyMap.get(ko);
            return new AbstractMap.SimpleEntry(ki, v);
        });
        return result;
    }

    public static <KI, KO, V> LookupService<KI, V> create(LookupService<KO, V> base, Function<? super KI, ? extends KO> keyMapper) {
        LookupServiceTransformKey<? super KI, ? extends KO, V> result = new LookupServiceTransformKey<KI, KO, V>(base, keyMapper);
        return result;
    }
}

