/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.lookup;

import com.google.common.collect.Range;
import com.google.common.primitives.Ints;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import org.aksw.commons.rx.lookup.ListPaginator;
import org.aksw.commons.util.range.RangeUtils;

public class ListPaginatorFromList<T>
implements ListPaginator<T> {
    protected List<T> backend;

    public ListPaginatorFromList(List<T> backend) {
        this.backend = backend;
    }

    @Override
    public Flowable<T> apply(Range<Long> t) {
        Range r = RangeUtils.apply(t, null, (e, v) -> Ints.checkedCast((long)e));
        List subList = RangeUtils.subList(this.backend, (Range)r);
        return Flowable.fromIterable((Iterable)subList);
    }

    @Override
    public Single<Range<Long>> fetchCount(Long itemLimit, Long rowLimit) {
        return Single.just((Object)Range.singleton((Comparable)Long.valueOf(this.backend.size())));
    }

    public static <T> ListPaginator<T> wrap(List<T> list) {
        return new ListPaginatorFromList<T>(list);
    }
}

