/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.lookup;

import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import org.aksw.commons.rx.lookup.ListPaginator;
import org.aksw.commons.util.range.RangeUtils;

public class ListPaginatorBatch<I>
implements ListPaginator<List<I>> {
    protected ListPaginator<I> base;
    protected long batchSize;

    public ListPaginatorBatch(ListPaginator<I> base, long batchSize) {
        this.base = base;
        this.batchSize = batchSize;
    }

    @Override
    public Flowable<List<I>> apply(Range<Long> range) {
        Range newRange = RangeUtils.multiplyByPageSize(range, (long)this.batchSize);
        Flowable in = (Flowable)this.base.apply(newRange);
        Flowable result = in.buffer((int)this.batchSize);
        return result;
    }

    @Override
    public Single<Range<Long>> fetchCount(Long itemLimit, Long rowLimit) {
        return this.base.fetchCount(itemLimit, rowLimit).map(countInfo -> {
            long baseCount = (Long)countInfo.lowerEndpoint();
            long n = (baseCount + this.batchSize - 1L) / this.batchSize;
            Range result = countInfo.hasUpperBound() ? Range.singleton((Comparable)Long.valueOf(n)) : Range.atLeast((Comparable)Long.valueOf(n));
            return result;
        });
    }
}

