/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.io;

import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import java.util.stream.Stream;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelOverIterator;
import org.aksw.commons.io.input.ReadableChannelSource;
import org.aksw.commons.rx.lookup.ListPaginator;
import org.aksw.commons.util.range.CountInfo;
import org.aksw.commons.util.range.RangeUtils;

public class ReadableChannelSourceRx<T>
implements ReadableChannelSource<T[]> {
    protected ArrayOps<T[]> arrayOps;
    protected ListPaginator<T> listPaginator;

    public ReadableChannelSourceRx(ArrayOps<T[]> arrayOps, ListPaginator<T> listPaginator) {
        this.arrayOps = arrayOps;
        this.listPaginator = listPaginator;
    }

    public ArrayOps<T[]> getArrayOps() {
        return this.arrayOps;
    }

    public static <T> ReadableChannelSource<T[]> create(ArrayOps<T[]> arrayOps, ListPaginator<T> listPaginator) {
        return new ReadableChannelSourceRx<T>(arrayOps, listPaginator);
    }

    public ReadableChannel<T[]> newReadableChannel(Range<Long> range) {
        Flowable flowable = (Flowable)this.listPaginator.apply(range);
        Stream stream = flowable.blockingStream();
        return new ReadableChannelOverIterator(this.arrayOps, stream.iterator(), stream::close);
    }

    public long size() {
        Range tmp = (Range)this.listPaginator.fetchCount(null, null).blockingGet();
        CountInfo ci = RangeUtils.toCountInfo((Range)tmp);
        long result = ci.isHasMoreItems() ? -1L : ci.getCount();
        return result;
    }
}

