/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.cache.range;

import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.Iterator;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.cache.AdvancedRangeCacheImpl;
import org.aksw.commons.io.input.ReadableChannelSource;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.io.slice.SliceMetaDataBasic;
import org.aksw.commons.rx.io.ReadableChannelSourceRx;
import org.aksw.commons.rx.lookup.ListPaginator;
import org.aksw.commons.rx.util.FlowableUtils;
import org.aksw.commons.util.range.CountInfo;
import org.aksw.commons.util.range.RangeUtils;

public class ListPaginatorWithAdvancedCache<T>
implements ListPaginator<T> {
    protected ListPaginator<T> backend;
    protected AdvancedRangeCacheImpl<T[]> core;
    protected Single<Range<Long>> countSingle;

    public ListPaginatorWithAdvancedCache(ListPaginator<T> backend, AdvancedRangeCacheImpl.Builder<T[]> cacheBuilder) {
        this.backend = backend;
        ArrayOps arrayOps = cacheBuilder.getSlice().getArrayOps();
        ReadableChannelSource<T[]> source = ReadableChannelSourceRx.create((ArrayOps<T[]>)arrayOps, backend);
        cacheBuilder.setDataSource(source);
        this.core = cacheBuilder.build();
        this.countSingle = backend.fetchCount(null, null).map(r -> {
            CountInfo countInfo = RangeUtils.toCountInfo((Range)r);
            if (!countInfo.isHasMoreItems()) {
                long count = countInfo.getCount();
                this.core.getSlice().mutateMetaData(metaData -> metaData.setKnownSize(count));
            }
            return r;
        }).cache();
    }

    public static <T> ListPaginatorWithAdvancedCache<T> create(ListPaginator<T> backend, AdvancedRangeCacheImpl.Builder<T[]> builder) {
        return new ListPaginatorWithAdvancedCache<T>(backend, builder);
    }

    public AdvancedRangeCacheImpl<T[]> getCore() {
        return this.core;
    }

    @Override
    public Single<Range<Long>> fetchCount(Long itemLimit, Long rowLimit) {
        long knownSize = (Long)this.core.getSlice().computeFromMetaData(false, SliceMetaDataBasic::getKnownSize);
        Single result = knownSize >= 0L ? Single.just((Object)Range.singleton((Comparable)Long.valueOf(knownSize))) : this.countSingle;
        return result;
    }

    @Override
    public Flowable<T> apply(Range<Long> range) {
        return ListPaginatorWithAdvancedCache.adapt((ArrayOps<T[]>)this.core.getSlice().getArrayOps(), this.core, range).doOnComplete(() -> this.core.getSlice().sync());
    }

    public static <T> Flowable<T> adapt(ArrayOps<T[]> arrayOps, ReadableChannelSource<T[]> source, Range<Long> range) {
        return FlowableUtils.createFlowableFromResource(() -> source.newReadableChannel(range), ReadableChannels::newIterator, Iterator::hasNext, Iterator::next, t -> {
            try {
                t.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

