/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.playground;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefFuture;
import org.aksw.commons.util.ref.RefFutureImpl;
import org.aksw.commons.util.ref.RefImpl;

public class CaffeineExperiments {
    public static void main(String[] args) throws InterruptedException, ExecutionException {
        AsyncLoadingCache cache = Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.SECONDS).evictionListener((key, ref, cause) -> {
            System.out.println("Evicted: " + key);
            ref.close();
        }).buildAsync(key -> {
            Ref r;
            try {
                System.out.println("Loading: " + key);
                Thread.sleep(1000L);
                System.out.println("Loaded: " + key);
                r = RefImpl.create((Object)key, null, () -> System.out.println("Released: " + key), null);
            }
            catch (Exception e) {
                System.out.println("loading interrupted");
                r = null;
            }
            return r;
        });
        CompletableFuture page1 = cache.get((Object)"page1");
        CompletableFuture page2 = cache.get((Object)"page2");
        CompletableFuture page3 = cache.get((Object)"page3");
        ((Ref)page2.get()).close();
        ((Ref)page3.get()).close();
        Thread.sleep(500L);
        RefFuture ref1 = RefFutureImpl.fromFuture((CompletableFuture)page1, null);
        RefFuture ref2 = ref1.acquire();
        ref1.close();
        ref2.close();
        System.out.println("going to sleep");
        Thread.sleep(5000L);
        System.out.println("done sleeping");
    }
}

