/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.op;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.aksw.commons.collector.core.Accumulators;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.Aggregator;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOperatorConditionalConcat<T, C>
implements FlowableOperator<T, T> {
    protected Aggregator<T, ?, C> aggregator;
    protected Function<? super C, Flowable<T>> tailFlowFactory;

    public FlowableOperatorConditionalConcat(Aggregator<T, ?, C> aggregator, Function<? super C, Flowable<T>> tailFlowFactory) {
        this.aggregator = aggregator;
        this.tailFlowFactory = tailFlowFactory;
    }

    public static <T, C> FlowableOperatorConditionalConcat<T, C> create(Aggregator<T, ?, C> aggregator, Function<C, Flowable<T>> tailFlowFactory) {
        return new FlowableOperatorConditionalConcat<T, C>(aggregator, tailFlowFactory);
    }

    public Subscriber<? super T> apply(Subscriber<? super T> downstream) throws Exception {
        return new SubscriberImpl(downstream);
    }

    public class SubscriberImpl
    implements FlowableSubscriber<T>,
    Subscription {
        protected Subscriber<? super T> downstream;
        protected Subscription upstream;
        protected boolean isInitialUpstreamComplete = false;
        protected Accumulator<T, ?, C> accumulator;
        protected AtomicLong downstreamDemand;

        public SubscriberImpl(Subscriber<? super T> downstream) {
            this.downstream = downstream;
            this.accumulator = Accumulators.synchronize((Accumulator)FlowableOperatorConditionalConcat.this.aggregator.createAccumulator());
            this.downstreamDemand = new AtomicLong();
        }

        public void onSubscribe(Subscription s) {
            if (this.upstream != null) {
                s.cancel();
            } else {
                long remainingDemand;
                this.upstream = s;
                if (!this.isInitialUpstreamComplete) {
                    this.downstream.onSubscribe((Subscription)this);
                }
                if ((remainingDemand = this.downstreamDemand.get()) != 0L) {
                    this.upstream.request(remainingDemand);
                }
            }
        }

        public void onNext(T item) {
            this.accumulator.accumulate(item);
            this.downstream.onNext(item);
            this.downstreamDemand.decrementAndGet();
        }

        public void onComplete() {
            if (!this.isInitialUpstreamComplete) {
                this.isInitialUpstreamComplete = true;
                this.upstream = null;
                Object accumulatedValue = this.accumulator.getValue();
                Flowable tailFlow = FlowableOperatorConditionalConcat.this.tailFlowFactory.apply(accumulatedValue);
                if (tailFlow != null) {
                    tailFlow.subscribe((FlowableSubscriber)this);
                }
            } else {
                this.downstream.onComplete();
            }
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.downstreamDemand, (long)n);
            }
        }

        public void cancel() {
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELLED;
        }
    }
}

