/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.util;

import io.reactivex.rxjava3.core.Flowable;
import java.util.AbstractMap;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class FlowableUtils {
    public static <R, I, T> Flowable<T> createFlowableFromResource(Callable<R> resourceSupplier, Function<? super R, I> resourceToIterator, Predicate<? super I> hasNext, Function<? super I, T> next, Consumer<? super R> closeResource) {
        Flowable result = Flowable.generate(() -> {
            Object in = resourceSupplier.call();
            return new AbstractMap.SimpleEntry(in, null);
        }, (state, emitter) -> {
            Object it = state.getValue();
            try {
                boolean hasMore;
                if (it == null) {
                    Object in = state.getKey();
                    it = resourceToIterator.apply((Object)in);
                    state.setValue(it);
                }
                if (hasMore = hasNext.test((Object)it)) {
                    Object value = next.apply((Object)it);
                    emitter.onNext(value);
                } else {
                    emitter.onComplete();
                }
            }
            catch (Exception e) {
                emitter.onError((Throwable)e);
            }
        }, state -> {
            Object in = state.getKey();
            if (in != null) {
                closeResource.accept((Object)in);
            }
        });
        return result;
    }
}

