/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.op;

import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.aksw.commons.rx.util.RxUtils;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class OperatorObserveThroughput<T>
implements FlowableOperator<T, T> {
    protected String name;
    protected long interval;
    protected Consumer<ThroughputEvent> eventHandler;

    public static void defaultThroughputEventHandler(ThroughputEvent event) {
        System.err.println("On " + event.name + "-" + event.instanceId + " seen item count = " + event.totalSeenItemCount + " - throughput: " + (double)event.totalSeenItemCount / event.elapsedSeconds + " items per second");
    }

    public static <T> OperatorObserveThroughput<T> create(String name, long interval) {
        return new OperatorObserveThroughput<T>(name, interval, OperatorObserveThroughput::defaultThroughputEventHandler);
    }

    public static <T> OperatorObserveThroughput<T> create(String name, long interval, Consumer<ThroughputEvent> eventHandler) {
        return new OperatorObserveThroughput<T>(name, interval, eventHandler);
    }

    public OperatorObserveThroughput(String name, long interval, Consumer<ThroughputEvent> eventHandler) {
        this.name = name;
        this.interval = interval;
        this.eventHandler = eventHandler;
    }

    public Subscriber<? super T> apply(Subscriber<? super T> downstream) throws Exception {
        return new SubscriberImpl(downstream);
    }

    public static class ThroughputEvent {
        public long eventInterval;
        public String name;
        long instanceId;
        double elapsedSeconds;
        long totalSeenItemCount;

        public ThroughputEvent(long eventInterval, String name, long instanceId, double elapsedSeconds, long totalSeenItemCount) {
            this.eventInterval = eventInterval;
            this.name = name;
            this.instanceId = instanceId;
            this.elapsedSeconds = elapsedSeconds;
            this.totalSeenItemCount = totalSeenItemCount;
        }
    }

    public class SubscriberImpl
    implements FlowableSubscriber<T>,
    Subscription {
        protected Subscriber<? super T> downstream;
        protected Subscription upstream;
        protected AtomicLong pending = new AtomicLong();
        int id;
        protected AtomicLong seenItems = new AtomicLong();
        long startTimeMillis;

        public SubscriberImpl(Subscriber<? super T> downstream) {
            this.downstream = downstream;
        }

        public void onSubscribe(Subscription s) {
            AtomicInteger n = RxUtils.nameMap.computeIfAbsent(OperatorObserveThroughput.this.name, k -> new AtomicInteger());
            this.id = n.incrementAndGet();
            this.startTimeMillis = System.currentTimeMillis();
            if (this.upstream != null) {
                s.cancel();
            } else {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                this.pending.addAndGet(n);
                this.upstream.request(1L);
            }
        }

        public void onNext(T item) {
            long elapsed = System.currentTimeMillis() - this.startTimeMillis;
            long counter = this.seenItems.getAndIncrement();
            if (counter % OperatorObserveThroughput.this.interval == 0L) {
                double totalElapsedSeconds = (double)elapsed * 0.001;
                ThroughputEvent event = new ThroughputEvent(OperatorObserveThroughput.this.interval, OperatorObserveThroughput.this.name, this.id, totalElapsedSeconds, counter);
                OperatorObserveThroughput.this.eventHandler.accept(event);
            }
            this.downstream.onNext(item);
            long remaining = this.pending.decrementAndGet();
            if (remaining > 0L) {
                this.upstream.request(1L);
            }
        }

        public void onComplete() {
            this.downstream.onComplete();
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void cancel() {
            this.upstream.cancel();
        }
    }
}

