/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.op;

import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOperatorReadAhead<T>
implements FlowableOperator<T, T> {
    protected int readAheadAmount;

    public FlowableOperatorReadAhead(int readAheadAmount) {
        this.readAheadAmount = readAheadAmount;
    }

    public static <T> FlowableOperatorReadAhead<T> create(int readAheadAmount) {
        return new FlowableOperatorReadAhead<T>(readAheadAmount);
    }

    public Subscriber<? super T> apply(Subscriber<? super T> downstream) throws Exception {
        return new SubscriberImpl(downstream);
    }

    public class SubscriberImpl
    implements FlowableSubscriber<T>,
    Subscription {
        protected Subscriber<? super T> downstream;
        protected Subscription upstream;
        protected boolean isUpstreamCompleted = false;
        protected Deque<T> queue;
        protected AtomicLong downstreamDemand;
        protected AtomicInteger readAheadCapacity;

        public SubscriberImpl(Subscriber<? super T> downstream) {
            this.downstream = downstream;
            this.queue = new ArrayDeque(FlowableOperatorReadAhead.this.readAheadAmount + 1);
            this.downstreamDemand = new AtomicLong();
            this.readAheadCapacity = new AtomicInteger(FlowableOperatorReadAhead.this.readAheadAmount + 1);
        }

        public void onSubscribe(Subscription s) {
            if (this.upstream != null) {
                s.cancel();
            } else {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        protected void drain() {
            int n = 0;
            while (!this.queue.isEmpty() && this.downstreamDemand.getAndUpdate(v -> v == 0L ? 0L : v - 1L) > 0L) {
                Object item = null;
                try {
                    item = this.queue.removeFirst();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                if (item != null) {
                    this.downstream.onNext(item);
                    ++n;
                    continue;
                }
                this.downstreamDemand.addAndGet(1L);
                break;
            }
            if (this.isUpstreamCompleted) {
                if (this.queue.isEmpty()) {
                    this.downstream.onComplete();
                }
            } else {
                int capacity;
                if (n != 0) {
                    this.readAheadCapacity.addAndGet(n);
                }
                if ((capacity = this.readAheadCapacity.getAndSet(0)) != 0) {
                    this.upstream.request((long)capacity);
                }
            }
        }

        public void onNext(T item) {
            this.queue.add(item);
            this.drain();
        }

        public void onComplete() {
            this.isUpstreamCompleted = true;
            this.drain();
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.downstreamDemand, (long)n);
            }
            this.drain();
        }

        public void cancel() {
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELLED;
        }
    }
}

