/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.rx.op;

import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.aksw.commons.util.stream.CollapseRunsOperationBase;
import org.aksw.commons.util.stream.CollapseRunsSpec;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOperatorCollapseRuns<T, K, V>
extends CollapseRunsOperationBase<T, K, V>
implements FlowableOperator<Map.Entry<K, V>, T> {
    public static <T, K, V> FlowableOperatorCollapseRuns<T, K, V> create(CollapseRunsSpec<T, K, V> spec) {
        return new FlowableOperatorCollapseRuns<T, K, V>(spec);
    }

    public FlowableOperatorCollapseRuns(CollapseRunsSpec<T, K, V> other) {
        super(other);
    }

    public Subscriber<? super T> apply(Subscriber<? super Map.Entry<K, V>> downstream) throws Exception {
        return new SubscriberImpl(downstream);
    }

    @Deprecated
    public FlowableTransformer<T, Map.Entry<K, V>> transformer() {
        return upstream -> upstream.lift((FlowableOperator)this);
    }

    public class SubscriberImpl
    implements FlowableSubscriber<T>,
    Subscription {
        protected Subscriber<? super Map.Entry<K, V>> downstream;
        protected Subscription upstream;
        protected K priorKey;
        protected K currentKey;
        protected long accNum = 0L;
        protected V currentAcc = null;
        protected volatile boolean isUpstreamComplete = false;
        protected volatile boolean lastItemSent = false;
        protected AtomicLong pending = new AtomicLong();

        public SubscriberImpl(Subscriber<? super Map.Entry<K, V>> downstream) {
            this.downstream = downstream;
        }

        public void onSubscribe(Subscription s) {
            if (this.upstream != null) {
                s.cancel();
            } else {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T item) {
            this.currentKey = FlowableOperatorCollapseRuns.this.getGroupKey.apply(item);
            boolean needMore = true;
            if (this.accNum == 0L) {
                this.priorKey = this.currentKey;
                this.currentAcc = FlowableOperatorCollapseRuns.this.accCtor.apply(this.accNum, this.currentKey);
                ++this.accNum;
            } else if (!FlowableOperatorCollapseRuns.this.groupKeyCompare.test(this.priorKey, this.currentKey)) {
                AbstractMap.SimpleEntry e = new AbstractMap.SimpleEntry(this.priorKey, this.currentAcc);
                needMore = this.pending.decrementAndGet() > 0L;
                this.downstream.onNext(e);
                this.currentAcc = FlowableOperatorCollapseRuns.this.accCtor.apply(this.accNum, this.currentKey);
                ++this.accNum;
            }
            if (this.currentAcc != null) {
                FlowableOperatorCollapseRuns.this.accAdd.apply(this.currentAcc, item);
            }
            this.priorKey = this.currentKey;
            if (needMore) {
                this.upstream.request(1L);
            }
        }

        protected void trySendLastItem() {
            if (this.isUpstreamComplete && !this.lastItemSent) {
                if (this.accNum != 0L) {
                    if (this.pending.get() > 0L) {
                        this.lastItemSent = true;
                        this.downstream.onNext(new AbstractMap.SimpleEntry(this.currentKey, this.currentAcc));
                        this.downstream.onComplete();
                    }
                } else {
                    this.lastItemSent = true;
                    this.downstream.onComplete();
                }
            }
        }

        public void onComplete() {
            this.isUpstreamComplete = true;
            this.trySendLastItem();
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void request(long n) {
            long before;
            if (SubscriptionHelper.validate((long)n) && (before = BackpressureHelper.add((AtomicLong)this.pending, (long)n)) == 0L) {
                this.upstream.request(1L);
            }
            this.trySendLastItem();
        }

        public void cancel() {
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELLED;
        }
    }
}

