/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.picocli;

import java.util.function.Predicate;
import org.aksw.commons.picocli.HasDebugMode;
import org.aksw.commons.util.exception.ExceptionUtilsAksw;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class CmdUtils {
    private static final Logger logger = LoggerFactory.getLogger(CmdUtils.class);

    public static void execCmd(Class<?> cmdClass, String[] args) {
        int exitCode = CmdUtils.callCmd(cmdClass, args);
        System.exit(exitCode);
    }

    public static void execCmdObject(Object cmdInstance, String[] args) {
        int exitCode = CmdUtils.callCmdObject(cmdInstance, args);
        System.exit(exitCode);
    }

    public static void execCmd(CommandLine cl, String[] args) {
        int exitCode = CmdUtils.callCmd(cl, args);
        System.exit(exitCode);
    }

    public static int callCmd(Class<?> cmdClass, String[] args) {
        try {
            Object cmd = cmdClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            int result = CmdUtils.callCmdObject(cmd, args);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int callCmdObject(Object cmdInstance, String[] args) {
        CommandLine cl = new CommandLine(cmdInstance);
        return CmdUtils.callCmd(cl, args);
    }

    public static int callCmd(CommandLine cl, String[] args) {
        int result = cl.setExecutionExceptionHandler((ex, commandLine, parseResult) -> {
            boolean debugMode;
            Object cmd = commandLine.getCommand();
            boolean bl = debugMode = cmd instanceof HasDebugMode ? ((HasDebugMode)cmd).isDebugMode() : true;
            if (debugMode) {
                ExceptionUtilsAksw.rethrowIfNotBrokenPipe((Throwable)ex);
            } else {
                ExceptionUtilsAksw.forwardRootCauseMessageUnless((Throwable)ex, arg_0 -> ((Logger)logger).error(arg_0), (Predicate[])new Predicate[]{ExceptionUtilsAksw::isBrokenPipeException});
            }
            return 0;
        }).execute(args);
        return result;
    }

    public static CommandLine registerIfAvailable(CommandLine commandLine, String className) {
        CommandLine result = null;
        try {
            Object cmd;
            Class<?> cmdCls = Class.forName(className);
            try {
                cmd = cmdCls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            result = commandLine.addSubcommand(cmd);
        }
        catch (ClassNotFoundException e) {
            logger.debug("A command was was not found: " + className);
        }
        return result;
    }
}

