/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.picocli;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.aksw.commons.io.util.StdIo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="cpcat", description={"Print out the content of classpath resources"})
public class CmdCatClasspathResource
implements Callable<Integer> {
    protected Logger logger = LoggerFactory.getLogger(CmdCatClasspathResource.class);
    @CommandLine.Parameters(arity="1..n", description={"Classpath resource names"})
    protected List<String> resourceNames = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        LinkedHashMap<String, InputStream> map = new LinkedHashMap<String, InputStream>();
        try {
            ArrayList<String> failedNames = new ArrayList<String>();
            for (String string : this.resourceNames) {
                InputStream inputStream = classLoader.getResourceAsStream(string);
                if (inputStream == null) {
                    failedNames.add(string);
                    continue;
                }
                map.put(string, inputStream);
            }
            if (!failedNames.isEmpty()) {
                throw new FileNotFoundException("The following classpath resources could not be opened: " + String.valueOf(failedNames));
            }
            try (OutputStream out = StdIo.openStdOut();){
                for (Map.Entry entry : map.entrySet()) {
                    ((InputStream)entry.getValue()).transferTo(out);
                }
            }
        }
        finally {
            for (Map.Entry entry : map.entrySet()) {
                try {
                    ((InputStream)entry.getValue()).close();
                }
                catch (Exception exception) {
                    this.logger.warn("Failed to close resource " + (String)entry.getKey(), (Throwable)exception);
                }
            }
        }
        return 0;
    }
}

